/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.ReportType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="CreditRelayRefreshRequest defines the request schema for `/credit/relay/refresh`")
public class CreditRelayRefreshRequest {
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_RELAY_TOKEN = "relay_token";
    @SerializedName(value="relay_token")
    private String relayToken;
    public static final String SERIALIZED_NAME_REPORT_TYPE = "report_type";
    @SerializedName(value="report_type")
    private ReportType reportType;
    public static final String SERIALIZED_NAME_WEBHOOK = "webhook";
    @SerializedName(value="webhook")
    private String webhook;

    public CreditRelayRefreshRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public CreditRelayRefreshRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public CreditRelayRefreshRequest relayToken(String relayToken) {
        this.relayToken = relayToken;
        return this;
    }

    @ApiModelProperty(required=true, value="The `relay_token` granting access to the report you would like to refresh.")
    public String getRelayToken() {
        return this.relayToken;
    }

    public void setRelayToken(String relayToken) {
        this.relayToken = relayToken;
    }

    public CreditRelayRefreshRequest reportType(ReportType reportType) {
        this.reportType = reportType;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public ReportType getReportType() {
        return this.reportType;
    }

    public void setReportType(ReportType reportType) {
        this.reportType = reportType;
    }

    public CreditRelayRefreshRequest webhook(String webhook) {
        this.webhook = webhook;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The URL registered to receive webhooks when the report of a relay token has been refreshed.")
    public String getWebhook() {
        return this.webhook;
    }

    public void setWebhook(String webhook) {
        this.webhook = webhook;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreditRelayRefreshRequest creditRelayRefreshRequest = (CreditRelayRefreshRequest)o;
        return Objects.equals(this.clientId, creditRelayRefreshRequest.clientId) && Objects.equals(this.secret, creditRelayRefreshRequest.secret) && Objects.equals(this.relayToken, creditRelayRefreshRequest.relayToken) && Objects.equals((Object)this.reportType, (Object)creditRelayRefreshRequest.reportType) && Objects.equals(this.webhook, creditRelayRefreshRequest.webhook);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.clientId, this.secret, this.relayToken, this.reportType, this.webhook});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreditRelayRefreshRequest {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    relayToken: ").append(this.toIndentedString(this.relayToken)).append("\n");
        sb.append("    reportType: ").append(this.toIndentedString((Object)this.reportType)).append("\n");
        sb.append("    webhook: ").append(this.toIndentedString(this.webhook)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

