/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="CreditRelayRemoveRequest defines the request schema for `/credit/relay/remove`")
public class CreditRelayRemoveRequest {
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_RELAY_TOKEN = "relay_token";
    @SerializedName(value="relay_token")
    private String relayToken;

    public CreditRelayRemoveRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public CreditRelayRemoveRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public CreditRelayRemoveRequest relayToken(String relayToken) {
        this.relayToken = relayToken;
        return this;
    }

    @ApiModelProperty(required=true, value="The `relay_token` you would like to revoke.")
    public String getRelayToken() {
        return this.relayToken;
    }

    public void setRelayToken(String relayToken) {
        this.relayToken = relayToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreditRelayRemoveRequest creditRelayRemoveRequest = (CreditRelayRemoveRequest)o;
        return Objects.equals(this.clientId, creditRelayRemoveRequest.clientId) && Objects.equals(this.secret, creditRelayRemoveRequest.secret) && Objects.equals(this.relayToken, creditRelayRemoveRequest.relayToken);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.secret, this.relayToken);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreditRelayRemoveRequest {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    relayToken: ").append(this.toIndentedString(this.relayToken)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

