/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.CreditSessionError;
import com.plaid.client.model.CreditSessionResults;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Metadata and results for a Link session")
public class CreditSession {
    public static final String SERIALIZED_NAME_LINK_SESSION_ID = "link_session_id";
    @SerializedName(value="link_session_id")
    private String linkSessionId;
    public static final String SERIALIZED_NAME_SESSION_START_TIME = "session_start_time";
    @SerializedName(value="session_start_time")
    private OffsetDateTime sessionStartTime;
    public static final String SERIALIZED_NAME_RESULTS = "results";
    @SerializedName(value="results")
    private CreditSessionResults results;
    public static final String SERIALIZED_NAME_ERRORS = "errors";
    @SerializedName(value="errors")
    private List<CreditSessionError> errors = null;

    public CreditSession linkSessionId(String linkSessionId) {
        this.linkSessionId = linkSessionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The unique identifier associated with the Link session. This identifier matches the `link_session_id` returned in the onSuccess/onExit callbacks.")
    public String getLinkSessionId() {
        return this.linkSessionId;
    }

    public void setLinkSessionId(String linkSessionId) {
        this.linkSessionId = linkSessionId;
    }

    public CreditSession sessionStartTime(OffsetDateTime sessionStartTime) {
        this.sessionStartTime = sessionStartTime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The time when the Link session started")
    public OffsetDateTime getSessionStartTime() {
        return this.sessionStartTime;
    }

    public void setSessionStartTime(OffsetDateTime sessionStartTime) {
        this.sessionStartTime = sessionStartTime;
    }

    public CreditSession results(CreditSessionResults results) {
        this.results = results;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public CreditSessionResults getResults() {
        return this.results;
    }

    public void setResults(CreditSessionResults results) {
        this.results = results;
    }

    public CreditSession errors(List<CreditSessionError> errors) {
        this.errors = errors;
        return this;
    }

    public CreditSession addErrorsItem(CreditSessionError errorsItem) {
        if (this.errors == null) {
            this.errors = new ArrayList<CreditSessionError>();
        }
        this.errors.add(errorsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The set of errors that occurred during the Link session.")
    public List<CreditSessionError> getErrors() {
        return this.errors;
    }

    public void setErrors(List<CreditSessionError> errors) {
        this.errors = errors;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreditSession creditSession = (CreditSession)o;
        return Objects.equals(this.linkSessionId, creditSession.linkSessionId) && Objects.equals(this.sessionStartTime, creditSession.sessionStartTime) && Objects.equals(this.results, creditSession.results) && Objects.equals(this.errors, creditSession.errors);
    }

    public int hashCode() {
        return Objects.hash(this.linkSessionId, this.sessionStartTime, this.results, this.errors);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreditSession {\n");
        sb.append("    linkSessionId: ").append(this.toIndentedString(this.linkSessionId)).append("\n");
        sb.append("    sessionStartTime: ").append(this.toIndentedString(this.sessionStartTime)).append("\n");
        sb.append("    results: ").append(this.toIndentedString(this.results)).append("\n");
        sb.append("    errors: ").append(this.toIndentedString(this.errors)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

