/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The details of an Item add in Link.")
public class CreditSessionItemAddResult {
    public static final String SERIALIZED_NAME_PUBLIC_TOKEN = "public_token";
    @SerializedName(value="public_token")
    private String publicToken;
    public static final String SERIALIZED_NAME_ITEM_ID = "item_id";
    @SerializedName(value="item_id")
    private String itemId;
    public static final String SERIALIZED_NAME_INSTITUTION_ID = "institution_id";
    @SerializedName(value="institution_id")
    private String institutionId;

    public CreditSessionItemAddResult publicToken(String publicToken) {
        this.publicToken = publicToken;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Returned once a user has successfully linked their Item.")
    public String getPublicToken() {
        return this.publicToken;
    }

    public void setPublicToken(String publicToken) {
        this.publicToken = publicToken;
    }

    public CreditSessionItemAddResult itemId(String itemId) {
        this.itemId = itemId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The Plaid Item ID. The `item_id` is always unique; linking the same account at the same institution twice will result in two Items with different `item_id` values. Like all Plaid identifiers, the `item_id` is case-sensitive.")
    public String getItemId() {
        return this.itemId;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    public CreditSessionItemAddResult institutionId(String institutionId) {
        this.institutionId = institutionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The Plaid Institution ID associated with the Item.")
    public String getInstitutionId() {
        return this.institutionId;
    }

    public void setInstitutionId(String institutionId) {
        this.institutionId = institutionId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreditSessionItemAddResult creditSessionItemAddResult = (CreditSessionItemAddResult)o;
        return Objects.equals(this.publicToken, creditSessionItemAddResult.publicToken) && Objects.equals(this.itemId, creditSessionItemAddResult.itemId) && Objects.equals(this.institutionId, creditSessionItemAddResult.institutionId);
    }

    public int hashCode() {
        return Objects.hash(this.publicToken, this.itemId, this.institutionId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreditSessionItemAddResult {\n");
        sb.append("    publicToken: ").append(this.toIndentedString(this.publicToken)).append("\n");
        sb.append("    itemId: ").append(this.toIndentedString(this.itemId)).append("\n");
        sb.append("    institutionId: ").append(this.toIndentedString(this.institutionId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

