/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The details of a digital payroll income verification in Link")
public class CreditSessionPayrollIncomeResult {
    public static final String SERIALIZED_NAME_NUM_PAYSTUBS_RETRIEVED = "num_paystubs_retrieved";
    @SerializedName(value="num_paystubs_retrieved")
    private Integer numPaystubsRetrieved;
    public static final String SERIALIZED_NAME_NUM_W2S_RETRIEVED = "num_w2s_retrieved";
    @SerializedName(value="num_w2s_retrieved")
    private Integer numW2sRetrieved;
    public static final String SERIALIZED_NAME_INSTITUTION_ID = "institution_id";
    @SerializedName(value="institution_id")
    private String institutionId;
    public static final String SERIALIZED_NAME_INSTITUTION_NAME = "institution_name";
    @SerializedName(value="institution_name")
    private String institutionName;

    public CreditSessionPayrollIncomeResult numPaystubsRetrieved(Integer numPaystubsRetrieved) {
        this.numPaystubsRetrieved = numPaystubsRetrieved;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of paystubs retrieved from a payroll provider.")
    public Integer getNumPaystubsRetrieved() {
        return this.numPaystubsRetrieved;
    }

    public void setNumPaystubsRetrieved(Integer numPaystubsRetrieved) {
        this.numPaystubsRetrieved = numPaystubsRetrieved;
    }

    public CreditSessionPayrollIncomeResult numW2sRetrieved(Integer numW2sRetrieved) {
        this.numW2sRetrieved = numW2sRetrieved;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The number of w2s retrieved from a payroll provider.")
    public Integer getNumW2sRetrieved() {
        return this.numW2sRetrieved;
    }

    public void setNumW2sRetrieved(Integer numW2sRetrieved) {
        this.numW2sRetrieved = numW2sRetrieved;
    }

    public CreditSessionPayrollIncomeResult institutionId(String institutionId) {
        this.institutionId = institutionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The Plaid Institution ID associated with the Item.")
    public String getInstitutionId() {
        return this.institutionId;
    }

    public void setInstitutionId(String institutionId) {
        this.institutionId = institutionId;
    }

    public CreditSessionPayrollIncomeResult institutionName(String institutionName) {
        this.institutionName = institutionName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The Institution Name associated with the Item.")
    public String getInstitutionName() {
        return this.institutionName;
    }

    public void setInstitutionName(String institutionName) {
        this.institutionName = institutionName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreditSessionPayrollIncomeResult creditSessionPayrollIncomeResult = (CreditSessionPayrollIncomeResult)o;
        return Objects.equals(this.numPaystubsRetrieved, creditSessionPayrollIncomeResult.numPaystubsRetrieved) && Objects.equals(this.numW2sRetrieved, creditSessionPayrollIncomeResult.numW2sRetrieved) && Objects.equals(this.institutionId, creditSessionPayrollIncomeResult.institutionId) && Objects.equals(this.institutionName, creditSessionPayrollIncomeResult.institutionName);
    }

    public int hashCode() {
        return Objects.hash(this.numPaystubsRetrieved, this.numW2sRetrieved, this.institutionId, this.institutionName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreditSessionPayrollIncomeResult {\n");
        sb.append("    numPaystubsRetrieved: ").append(this.toIndentedString(this.numPaystubsRetrieved)).append("\n");
        sb.append("    numW2sRetrieved: ").append(this.toIndentedString(this.numW2sRetrieved)).append("\n");
        sb.append("    institutionId: ").append(this.toIndentedString(this.institutionId)).append("\n");
        sb.append("    institutionName: ").append(this.toIndentedString(this.institutionName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

