/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="The object contains a risk score and a risk tier that evaluate the transaction return risk of an unauthorized debit. Common return codes in this category include: \"R05\", \"R07\", \"R10\", \"R11\", \"R29\". These returns typically have a return time frame of up to 60 calendar days. During this period, the customer of financial institutions can dispute a transaction as unauthorized.")
public class CustomerInitiatedReturnRisk {
    public static final String SERIALIZED_NAME_SCORE = "score";
    @SerializedName(value="score")
    private Integer score;
    public static final String SERIALIZED_NAME_RISK_TIER = "risk_tier";
    @SerializedName(value="risk_tier")
    private Integer riskTier;

    public CustomerInitiatedReturnRisk score(Integer score) {
        this.score = score;
        return this;
    }

    @ApiModelProperty(required=true, value="A score from 1-99 that indicates the transaction return risk: a higher risk score suggests a higher return likelihood.")
    public Integer getScore() {
        return this.score;
    }

    public void setScore(Integer score) {
        this.score = score;
    }

    public CustomerInitiatedReturnRisk riskTier(Integer riskTier) {
        this.riskTier = riskTier;
        return this;
    }

    @ApiModelProperty(required=true, value="A tier corresponding to the projected likelihood that the transaction, if initiated, will be subject to a return.  In the `customer_initiated_return_risk` object, there are five risk tiers corresponding to the scores:   1: Predicted customer-initiated return incidence rate between 0.00% - 0.02%   2: Predicted customer-initiated return incidence rate between 0.02% - 0.05%   3: Predicted customer-initiated return incidence rate between 0.05% - 0.1%   4: Predicted customer-initiated return incidence rate between 0.1% - 0.5%   5: Predicted customer-initiated return incidence rate greater than 0.5% ")
    public Integer getRiskTier() {
        return this.riskTier;
    }

    public void setRiskTier(Integer riskTier) {
        this.riskTier = riskTier;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CustomerInitiatedReturnRisk customerInitiatedReturnRisk = (CustomerInitiatedReturnRisk)o;
        return Objects.equals(this.score, customerInitiatedReturnRisk.score) && Objects.equals(this.riskTier, customerInitiatedReturnRisk.riskTier);
    }

    public int hashCode() {
        return Objects.hash(this.score, this.riskTier);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CustomerInitiatedReturnRisk {\n");
        sb.append("    score: ").append(this.toIndentedString(this.score)).append("\n");
        sb.append("    riskTier: ").append(this.toIndentedString(this.riskTier)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

