/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Request input for listing dashboard users")
public class DashboardUserListRequest {
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_CURSOR = "cursor";
    @SerializedName(value="cursor")
    private String cursor;

    public DashboardUserListRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public DashboardUserListRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public DashboardUserListRequest cursor(String cursor) {
        this.cursor = cursor;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="eyJkaXJlY3Rpb24iOiJuZXh0Iiwib2Zmc2V0IjoiMTU5NDM", value="An identifier that determines which page of results you receive.")
    public String getCursor() {
        return this.cursor;
    }

    public void setCursor(String cursor) {
        this.cursor = cursor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DashboardUserListRequest dashboardUserListRequest = (DashboardUserListRequest)o;
        return Objects.equals(this.secret, dashboardUserListRequest.secret) && Objects.equals(this.clientId, dashboardUserListRequest.clientId) && Objects.equals(this.cursor, dashboardUserListRequest.cursor);
    }

    public int hashCode() {
        return Objects.hash(this.secret, this.clientId, this.cursor);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DashboardUserListRequest {\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    cursor: ").append(this.toIndentedString(this.cursor)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

