/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.DashboardUser;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Paginated list of dashboard users")
public class DashboardUserListResponse {
    public static final String SERIALIZED_NAME_DASHBOARD_USERS = "dashboard_users";
    @SerializedName(value="dashboard_users")
    private List<DashboardUser> dashboardUsers = new ArrayList<DashboardUser>();
    public static final String SERIALIZED_NAME_NEXT_CURSOR = "next_cursor";
    @SerializedName(value="next_cursor")
    private String nextCursor;
    public static final String SERIALIZED_NAME_REQUEST_ID = "request_id";
    @SerializedName(value="request_id")
    private String requestId;

    public DashboardUserListResponse dashboardUsers(List<DashboardUser> dashboardUsers) {
        this.dashboardUsers = dashboardUsers;
        return this;
    }

    public DashboardUserListResponse addDashboardUsersItem(DashboardUser dashboardUsersItem) {
        this.dashboardUsers.add(dashboardUsersItem);
        return this;
    }

    @ApiModelProperty(required=true, value="List of dashboard users")
    public List<DashboardUser> getDashboardUsers() {
        return this.dashboardUsers;
    }

    public void setDashboardUsers(List<DashboardUser> dashboardUsers) {
        this.dashboardUsers = dashboardUsers;
    }

    public DashboardUserListResponse nextCursor(String nextCursor) {
        this.nextCursor = nextCursor;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="eyJkaXJlY3Rpb24iOiJuZXh0Iiwib2Zmc2V0IjoiMTU5NDM", required=true, value="An identifier that determines which page of results you receive.")
    public String getNextCursor() {
        return this.nextCursor;
    }

    public void setNextCursor(String nextCursor) {
        this.nextCursor = nextCursor;
    }

    public DashboardUserListResponse requestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    @ApiModelProperty(required=true, value="A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.")
    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DashboardUserListResponse dashboardUserListResponse = (DashboardUserListResponse)o;
        return Objects.equals(this.dashboardUsers, dashboardUserListResponse.dashboardUsers) && Objects.equals(this.nextCursor, dashboardUserListResponse.nextCursor) && Objects.equals(this.requestId, dashboardUserListResponse.requestId);
    }

    public int hashCode() {
        return Objects.hash(this.dashboardUsers, this.nextCursor, this.requestId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DashboardUserListResponse {\n");
        sb.append("    dashboardUsers: ").append(this.toIndentedString(this.dashboardUsers)).append("\n");
        sb.append("    nextCursor: ").append(this.toIndentedString(this.nextCursor)).append("\n");
        sb.append("    requestId: ").append(this.toIndentedString(this.requestId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

