/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.Objects;

@ApiModel(description="A date range with a start and end date")
public class DateRange {
    public static final String SERIALIZED_NAME_BEGINNING = "beginning";
    @SerializedName(value="beginning")
    private LocalDate beginning;
    public static final String SERIALIZED_NAME_ENDING = "ending";
    @SerializedName(value="ending")
    private LocalDate ending;

    public DateRange beginning(LocalDate beginning) {
        this.beginning = beginning;
        return this;
    }

    @ApiModelProperty(example="Tue May 29 00:00:00 UTC 1990", required=true, value="A date in the format YYYY-MM-DD (RFC 3339 Section 5.6).")
    public LocalDate getBeginning() {
        return this.beginning;
    }

    public void setBeginning(LocalDate beginning) {
        this.beginning = beginning;
    }

    public DateRange ending(LocalDate ending) {
        this.ending = ending;
        return this;
    }

    @ApiModelProperty(example="Tue May 29 00:00:00 UTC 1990", required=true, value="A date in the format YYYY-MM-DD (RFC 3339 Section 5.6).")
    public LocalDate getEnding() {
        return this.ending;
    }

    public void setEnding(LocalDate ending) {
        this.ending = ending;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DateRange dateRange = (DateRange)o;
        return Objects.equals(this.beginning, dateRange.beginning) && Objects.equals(this.ending, dateRange.ending);
    }

    public int hashCode() {
        return Objects.hash(this.beginning, this.ending);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DateRange {\n");
        sb.append("    beginning: ").append(this.toIndentedString(this.beginning)).append("\n");
        sb.append("    ending: ").append(this.toIndentedString(this.ending)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

