/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.plaid.client.model.DepositSwitchCreateRequestOptions;
import com.plaid.client.model.DepositSwitchTargetAccount;
import com.plaid.client.model.DepositSwitchTargetUser;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="DepositSwitchAltCreateRequest defines the request schema for `/deposit_switch/alt/create`")
public class DepositSwitchAltCreateRequest {
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_TARGET_ACCOUNT = "target_account";
    @SerializedName(value="target_account")
    private DepositSwitchTargetAccount targetAccount;
    public static final String SERIALIZED_NAME_TARGET_USER = "target_user";
    @SerializedName(value="target_user")
    private DepositSwitchTargetUser targetUser;
    public static final String SERIALIZED_NAME_OPTIONS = "options";
    @SerializedName(value="options")
    private DepositSwitchCreateRequestOptions options;
    public static final String SERIALIZED_NAME_COUNTRY_CODE = "country_code";
    @SerializedName(value="country_code")
    private CountryCodeEnum countryCode;

    public DepositSwitchAltCreateRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public DepositSwitchAltCreateRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public DepositSwitchAltCreateRequest targetAccount(DepositSwitchTargetAccount targetAccount) {
        this.targetAccount = targetAccount;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public DepositSwitchTargetAccount getTargetAccount() {
        return this.targetAccount;
    }

    public void setTargetAccount(DepositSwitchTargetAccount targetAccount) {
        this.targetAccount = targetAccount;
    }

    public DepositSwitchAltCreateRequest targetUser(DepositSwitchTargetUser targetUser) {
        this.targetUser = targetUser;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public DepositSwitchTargetUser getTargetUser() {
        return this.targetUser;
    }

    public void setTargetUser(DepositSwitchTargetUser targetUser) {
        this.targetUser = targetUser;
    }

    public DepositSwitchAltCreateRequest options(DepositSwitchCreateRequestOptions options) {
        this.options = options;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public DepositSwitchCreateRequestOptions getOptions() {
        return this.options;
    }

    public void setOptions(DepositSwitchCreateRequestOptions options) {
        this.options = options;
    }

    public DepositSwitchAltCreateRequest countryCode(CountryCodeEnum countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ISO-3166-1 alpha-2 country code standard.")
    public CountryCodeEnum getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(CountryCodeEnum countryCode) {
        this.countryCode = countryCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DepositSwitchAltCreateRequest depositSwitchAltCreateRequest = (DepositSwitchAltCreateRequest)o;
        return Objects.equals(this.clientId, depositSwitchAltCreateRequest.clientId) && Objects.equals(this.secret, depositSwitchAltCreateRequest.secret) && Objects.equals(this.targetAccount, depositSwitchAltCreateRequest.targetAccount) && Objects.equals(this.targetUser, depositSwitchAltCreateRequest.targetUser) && Objects.equals(this.options, depositSwitchAltCreateRequest.options) && Objects.equals((Object)this.countryCode, (Object)depositSwitchAltCreateRequest.countryCode);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.clientId, this.secret, this.targetAccount, this.targetUser, this.options, this.countryCode});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DepositSwitchAltCreateRequest {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    targetAccount: ").append(this.toIndentedString(this.targetAccount)).append("\n");
        sb.append("    targetUser: ").append(this.toIndentedString(this.targetUser)).append("\n");
        sb.append("    options: ").append(this.toIndentedString(this.options)).append("\n");
        sb.append("    countryCode: ").append(this.toIndentedString((Object)this.countryCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum CountryCodeEnum {
        US("US"),
        CA("CA");

        private String value;

        private CountryCodeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static CountryCodeEnum fromValue(String value) {
            for (CountryCodeEnum b : CountryCodeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<CountryCodeEnum> {
            public void write(JsonWriter jsonWriter, CountryCodeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public CountryCodeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return CountryCodeEnum.fromValue(value);
            }
        }
    }
}

