/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.plaid.client.model.DepositSwitchCreateRequestOptions;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="DepositSwitchCreateRequest defines the request schema for `/deposit_switch/create`")
public class DepositSwitchCreateRequest {
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_TARGET_ACCESS_TOKEN = "target_access_token";
    @SerializedName(value="target_access_token")
    private String targetAccessToken;
    public static final String SERIALIZED_NAME_TARGET_ACCOUNT_ID = "target_account_id";
    @SerializedName(value="target_account_id")
    private String targetAccountId;
    public static final String SERIALIZED_NAME_COUNTRY_CODE = "country_code";
    @SerializedName(value="country_code")
    private CountryCodeEnum countryCode;
    public static final String SERIALIZED_NAME_OPTIONS = "options";
    @SerializedName(value="options")
    private DepositSwitchCreateRequestOptions options;

    public DepositSwitchCreateRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public DepositSwitchCreateRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public DepositSwitchCreateRequest targetAccessToken(String targetAccessToken) {
        this.targetAccessToken = targetAccessToken;
        return this;
    }

    @ApiModelProperty(required=true, value="Access token for the target Item, typically provided in the Import Item response. ")
    public String getTargetAccessToken() {
        return this.targetAccessToken;
    }

    public void setTargetAccessToken(String targetAccessToken) {
        this.targetAccessToken = targetAccessToken;
    }

    public DepositSwitchCreateRequest targetAccountId(String targetAccountId) {
        this.targetAccountId = targetAccountId;
        return this;
    }

    @ApiModelProperty(required=true, value="Plaid Account ID that specifies the target bank account. This account will become the recipient for a user's direct deposit.")
    public String getTargetAccountId() {
        return this.targetAccountId;
    }

    public void setTargetAccountId(String targetAccountId) {
        this.targetAccountId = targetAccountId;
    }

    public DepositSwitchCreateRequest countryCode(CountryCodeEnum countryCode) {
        this.countryCode = countryCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="ISO-3166-1 alpha-2 country code standard.")
    public CountryCodeEnum getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(CountryCodeEnum countryCode) {
        this.countryCode = countryCode;
    }

    public DepositSwitchCreateRequest options(DepositSwitchCreateRequestOptions options) {
        this.options = options;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public DepositSwitchCreateRequestOptions getOptions() {
        return this.options;
    }

    public void setOptions(DepositSwitchCreateRequestOptions options) {
        this.options = options;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DepositSwitchCreateRequest depositSwitchCreateRequest = (DepositSwitchCreateRequest)o;
        return Objects.equals(this.clientId, depositSwitchCreateRequest.clientId) && Objects.equals(this.secret, depositSwitchCreateRequest.secret) && Objects.equals(this.targetAccessToken, depositSwitchCreateRequest.targetAccessToken) && Objects.equals(this.targetAccountId, depositSwitchCreateRequest.targetAccountId) && Objects.equals((Object)this.countryCode, (Object)depositSwitchCreateRequest.countryCode) && Objects.equals(this.options, depositSwitchCreateRequest.options);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.clientId, this.secret, this.targetAccessToken, this.targetAccountId, this.countryCode, this.options});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DepositSwitchCreateRequest {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    targetAccessToken: ").append(this.toIndentedString(this.targetAccessToken)).append("\n");
        sb.append("    targetAccountId: ").append(this.toIndentedString(this.targetAccountId)).append("\n");
        sb.append("    countryCode: ").append(this.toIndentedString((Object)this.countryCode)).append("\n");
        sb.append("    options: ").append(this.toIndentedString(this.options)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum CountryCodeEnum {
        US("US"),
        CA("CA");

        private String value;

        private CountryCodeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static CountryCodeEnum fromValue(String value) {
            for (CountryCodeEnum b : CountryCodeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<CountryCodeEnum> {
            public void write(JsonWriter jsonWriter, CountryCodeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public CountryCodeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return CountryCodeEnum.fromValue(value);
            }
        }
    }
}

