/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Options to configure the `/deposit_switch/create` request. If provided, cannot be `null`.")
public class DepositSwitchCreateRequestOptions {
    public static final String SERIALIZED_NAME_WEBHOOK = "webhook";
    @SerializedName(value="webhook")
    private String webhook;
    public static final String SERIALIZED_NAME_TRANSACTION_ITEM_ACCESS_TOKENS = "transaction_item_access_tokens";
    @SerializedName(value="transaction_item_access_tokens")
    private List<String> transactionItemAccessTokens = null;

    public DepositSwitchCreateRequestOptions webhook(String webhook) {
        this.webhook = webhook;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The URL registered to receive webhooks when the status of a deposit switch request has changed. ")
    public String getWebhook() {
        return this.webhook;
    }

    public void setWebhook(String webhook) {
        this.webhook = webhook;
    }

    public DepositSwitchCreateRequestOptions transactionItemAccessTokens(List<String> transactionItemAccessTokens) {
        this.transactionItemAccessTokens = transactionItemAccessTokens;
        return this;
    }

    public DepositSwitchCreateRequestOptions addTransactionItemAccessTokensItem(String transactionItemAccessTokensItem) {
        if (this.transactionItemAccessTokens == null) {
            this.transactionItemAccessTokens = new ArrayList<String>();
        }
        this.transactionItemAccessTokens.add(transactionItemAccessTokensItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An array of access tokens corresponding to transaction items to use when attempting to match the user to their Payroll Provider. These tokens must be created by the same client id as the one creating the switch, and have access to the transactions product.")
    public List<String> getTransactionItemAccessTokens() {
        return this.transactionItemAccessTokens;
    }

    public void setTransactionItemAccessTokens(List<String> transactionItemAccessTokens) {
        this.transactionItemAccessTokens = transactionItemAccessTokens;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DepositSwitchCreateRequestOptions depositSwitchCreateRequestOptions = (DepositSwitchCreateRequestOptions)o;
        return Objects.equals(this.webhook, depositSwitchCreateRequestOptions.webhook) && Objects.equals(this.transactionItemAccessTokens, depositSwitchCreateRequestOptions.transactionItemAccessTokens);
    }

    public int hashCode() {
        return Objects.hash(this.webhook, this.transactionItemAccessTokens);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DepositSwitchCreateRequestOptions {\n");
        sb.append("    webhook: ").append(this.toIndentedString(this.webhook)).append("\n");
        sb.append("    transactionItemAccessTokens: ").append(this.toIndentedString(this.transactionItemAccessTokens)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

