/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.time.LocalDate;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="DepositSwitchGetResponse defines the response schema for `/deposit_switch/get`")
public class DepositSwitchGetResponse {
    public static final String SERIALIZED_NAME_DEPOSIT_SWITCH_ID = "deposit_switch_id";
    @SerializedName(value="deposit_switch_id")
    private String depositSwitchId;
    public static final String SERIALIZED_NAME_TARGET_ACCOUNT_ID = "target_account_id";
    @SerializedName(value="target_account_id")
    private String targetAccountId;
    public static final String SERIALIZED_NAME_TARGET_ITEM_ID = "target_item_id";
    @SerializedName(value="target_item_id")
    private String targetItemId;
    public static final String SERIALIZED_NAME_STATE = "state";
    @SerializedName(value="state")
    private StateEnum state;
    public static final String SERIALIZED_NAME_SWITCH_METHOD = "switch_method";
    @SerializedName(value="switch_method")
    private SwitchMethodEnum switchMethod;
    public static final String SERIALIZED_NAME_ACCOUNT_HAS_MULTIPLE_ALLOCATIONS = "account_has_multiple_allocations";
    @SerializedName(value="account_has_multiple_allocations")
    private Boolean accountHasMultipleAllocations;
    public static final String SERIALIZED_NAME_IS_ALLOCATED_REMAINDER = "is_allocated_remainder";
    @SerializedName(value="is_allocated_remainder")
    private Boolean isAllocatedRemainder;
    public static final String SERIALIZED_NAME_PERCENT_ALLOCATED = "percent_allocated";
    @SerializedName(value="percent_allocated")
    private Double percentAllocated;
    public static final String SERIALIZED_NAME_AMOUNT_ALLOCATED = "amount_allocated";
    @SerializedName(value="amount_allocated")
    private Double amountAllocated;
    public static final String SERIALIZED_NAME_EMPLOYER_NAME = "employer_name";
    @SerializedName(value="employer_name")
    private String employerName;
    public static final String SERIALIZED_NAME_EMPLOYER_ID = "employer_id";
    @SerializedName(value="employer_id")
    private String employerId;
    public static final String SERIALIZED_NAME_INSTITUTION_NAME = "institution_name";
    @SerializedName(value="institution_name")
    private String institutionName;
    public static final String SERIALIZED_NAME_INSTITUTION_ID = "institution_id";
    @SerializedName(value="institution_id")
    private String institutionId;
    public static final String SERIALIZED_NAME_DATE_CREATED = "date_created";
    @SerializedName(value="date_created")
    private LocalDate dateCreated;
    public static final String SERIALIZED_NAME_DATE_COMPLETED = "date_completed";
    @SerializedName(value="date_completed")
    private LocalDate dateCompleted;
    public static final String SERIALIZED_NAME_REQUEST_ID = "request_id";
    @SerializedName(value="request_id")
    private String requestId;

    public DepositSwitchGetResponse depositSwitchId(String depositSwitchId) {
        this.depositSwitchId = depositSwitchId;
        return this;
    }

    @ApiModelProperty(required=true, value="The ID of the deposit switch.")
    public String getDepositSwitchId() {
        return this.depositSwitchId;
    }

    public void setDepositSwitchId(String depositSwitchId) {
        this.depositSwitchId = depositSwitchId;
    }

    public DepositSwitchGetResponse targetAccountId(String targetAccountId) {
        this.targetAccountId = targetAccountId;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The ID of the bank account the direct deposit was switched to.")
    public String getTargetAccountId() {
        return this.targetAccountId;
    }

    public void setTargetAccountId(String targetAccountId) {
        this.targetAccountId = targetAccountId;
    }

    public DepositSwitchGetResponse targetItemId(String targetItemId) {
        this.targetItemId = targetItemId;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The ID of the Item the direct deposit was switched to.")
    public String getTargetItemId() {
        return this.targetItemId;
    }

    public void setTargetItemId(String targetItemId) {
        this.targetItemId = targetItemId;
    }

    public DepositSwitchGetResponse state(StateEnum state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(required=true, value=" The state, or status, of the deposit switch.  - `initialized` \u2013 The deposit switch has been initialized with the user entering the information required to submit the deposit switch request.  - `processing` \u2013 The deposit switch request has been submitted and is being processed.  - `completed` \u2013 The user's employer has fulfilled the deposit switch request.  - `error` \u2013 There was an error processing the deposit switch request.")
    public StateEnum getState() {
        return this.state;
    }

    public void setState(StateEnum state) {
        this.state = state;
    }

    public DepositSwitchGetResponse switchMethod(SwitchMethodEnum switchMethod) {
        this.switchMethod = switchMethod;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The method used to make the deposit switch.  - `instant` \u2013 User instantly switched their direct deposit to a new or existing bank account by connecting their payroll or employer account.  - `mail` \u2013 User requested that Plaid contact their employer by mail to make the direct deposit switch.  - `pdf` \u2013 User generated a PDF or email to be sent to their employer with the information necessary to make the deposit switch.'")
    public SwitchMethodEnum getSwitchMethod() {
        return this.switchMethod;
    }

    public void setSwitchMethod(SwitchMethodEnum switchMethod) {
        this.switchMethod = switchMethod;
    }

    public DepositSwitchGetResponse accountHasMultipleAllocations(Boolean accountHasMultipleAllocations) {
        this.accountHasMultipleAllocations = accountHasMultipleAllocations;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="When `true`, user\u2019s direct deposit goes to multiple banks. When false, user\u2019s direct deposit only goes to the target account. Always `null` if the deposit switch has not been completed.")
    public Boolean getAccountHasMultipleAllocations() {
        return this.accountHasMultipleAllocations;
    }

    public void setAccountHasMultipleAllocations(Boolean accountHasMultipleAllocations) {
        this.accountHasMultipleAllocations = accountHasMultipleAllocations;
    }

    public DepositSwitchGetResponse isAllocatedRemainder(Boolean isAllocatedRemainder) {
        this.isAllocatedRemainder = isAllocatedRemainder;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="When `true`, the target account is allocated the remainder of direct deposit after all other allocations have been deducted. When `false`, user\u2019s direct deposit is allocated as a percent or amount. Always `null` if the deposit switch has not been completed.")
    public Boolean getIsAllocatedRemainder() {
        return this.isAllocatedRemainder;
    }

    public void setIsAllocatedRemainder(Boolean isAllocatedRemainder) {
        this.isAllocatedRemainder = isAllocatedRemainder;
    }

    public DepositSwitchGetResponse percentAllocated(Double percentAllocated) {
        this.percentAllocated = percentAllocated;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The percentage of direct deposit allocated to the target account. Always `null` if the target account is not allocated a percentage or if the deposit switch has not been completed or if `is_allocated_remainder` is true.")
    public Double getPercentAllocated() {
        return this.percentAllocated;
    }

    public void setPercentAllocated(Double percentAllocated) {
        this.percentAllocated = percentAllocated;
    }

    public DepositSwitchGetResponse amountAllocated(Double amountAllocated) {
        this.amountAllocated = amountAllocated;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The dollar amount of direct deposit allocated to the target account. Always `null` if the target account is not allocated an amount or if the deposit switch has not been completed.")
    public Double getAmountAllocated() {
        return this.amountAllocated;
    }

    public void setAmountAllocated(Double amountAllocated) {
        this.amountAllocated = amountAllocated;
    }

    public DepositSwitchGetResponse employerName(String employerName) {
        this.employerName = employerName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of the employer selected by the user. If the user did not select an employer, the value returned is `null`.")
    public String getEmployerName() {
        return this.employerName;
    }

    public void setEmployerName(String employerName) {
        this.employerName = employerName;
    }

    public DepositSwitchGetResponse employerId(String employerId) {
        this.employerId = employerId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The ID of the employer selected by the user. If the user did not select an employer, the value returned is `null`.")
    public String getEmployerId() {
        return this.employerId;
    }

    public void setEmployerId(String employerId) {
        this.employerId = employerId;
    }

    public DepositSwitchGetResponse institutionName(String institutionName) {
        this.institutionName = institutionName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of the institution selected by the user. If the user did not select an institution, the value returned is `null`.")
    public String getInstitutionName() {
        return this.institutionName;
    }

    public void setInstitutionName(String institutionName) {
        this.institutionName = institutionName;
    }

    public DepositSwitchGetResponse institutionId(String institutionId) {
        this.institutionId = institutionId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The ID of the institution selected by the user. If the user did not select an institution, the value returned is `null`.")
    public String getInstitutionId() {
        return this.institutionId;
    }

    public void setInstitutionId(String institutionId) {
        this.institutionId = institutionId;
    }

    public DepositSwitchGetResponse dateCreated(LocalDate dateCreated) {
        this.dateCreated = dateCreated;
        return this;
    }

    @ApiModelProperty(required=true, value="[ISO 8601](https://wikipedia.org/wiki/ISO_8601) date the deposit switch was created. ")
    public LocalDate getDateCreated() {
        return this.dateCreated;
    }

    public void setDateCreated(LocalDate dateCreated) {
        this.dateCreated = dateCreated;
    }

    public DepositSwitchGetResponse dateCompleted(LocalDate dateCompleted) {
        this.dateCompleted = dateCompleted;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="[ISO 8601](https://wikipedia.org/wiki/ISO_8601) date the deposit switch was completed. Always `null` if the deposit switch has not been completed. ")
    public LocalDate getDateCompleted() {
        return this.dateCompleted;
    }

    public void setDateCompleted(LocalDate dateCompleted) {
        this.dateCompleted = dateCompleted;
    }

    public DepositSwitchGetResponse requestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    @ApiModelProperty(required=true, value="A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.")
    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DepositSwitchGetResponse depositSwitchGetResponse = (DepositSwitchGetResponse)o;
        return Objects.equals(this.depositSwitchId, depositSwitchGetResponse.depositSwitchId) && Objects.equals(this.targetAccountId, depositSwitchGetResponse.targetAccountId) && Objects.equals(this.targetItemId, depositSwitchGetResponse.targetItemId) && Objects.equals((Object)this.state, (Object)depositSwitchGetResponse.state) && Objects.equals((Object)this.switchMethod, (Object)depositSwitchGetResponse.switchMethod) && Objects.equals(this.accountHasMultipleAllocations, depositSwitchGetResponse.accountHasMultipleAllocations) && Objects.equals(this.isAllocatedRemainder, depositSwitchGetResponse.isAllocatedRemainder) && Objects.equals(this.percentAllocated, depositSwitchGetResponse.percentAllocated) && Objects.equals(this.amountAllocated, depositSwitchGetResponse.amountAllocated) && Objects.equals(this.employerName, depositSwitchGetResponse.employerName) && Objects.equals(this.employerId, depositSwitchGetResponse.employerId) && Objects.equals(this.institutionName, depositSwitchGetResponse.institutionName) && Objects.equals(this.institutionId, depositSwitchGetResponse.institutionId) && Objects.equals(this.dateCreated, depositSwitchGetResponse.dateCreated) && Objects.equals(this.dateCompleted, depositSwitchGetResponse.dateCompleted) && Objects.equals(this.requestId, depositSwitchGetResponse.requestId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.depositSwitchId, this.targetAccountId, this.targetItemId, this.state, this.switchMethod, this.accountHasMultipleAllocations, this.isAllocatedRemainder, this.percentAllocated, this.amountAllocated, this.employerName, this.employerId, this.institutionName, this.institutionId, this.dateCreated, this.dateCompleted, this.requestId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DepositSwitchGetResponse {\n");
        sb.append("    depositSwitchId: ").append(this.toIndentedString(this.depositSwitchId)).append("\n");
        sb.append("    targetAccountId: ").append(this.toIndentedString(this.targetAccountId)).append("\n");
        sb.append("    targetItemId: ").append(this.toIndentedString(this.targetItemId)).append("\n");
        sb.append("    state: ").append(this.toIndentedString((Object)this.state)).append("\n");
        sb.append("    switchMethod: ").append(this.toIndentedString((Object)this.switchMethod)).append("\n");
        sb.append("    accountHasMultipleAllocations: ").append(this.toIndentedString(this.accountHasMultipleAllocations)).append("\n");
        sb.append("    isAllocatedRemainder: ").append(this.toIndentedString(this.isAllocatedRemainder)).append("\n");
        sb.append("    percentAllocated: ").append(this.toIndentedString(this.percentAllocated)).append("\n");
        sb.append("    amountAllocated: ").append(this.toIndentedString(this.amountAllocated)).append("\n");
        sb.append("    employerName: ").append(this.toIndentedString(this.employerName)).append("\n");
        sb.append("    employerId: ").append(this.toIndentedString(this.employerId)).append("\n");
        sb.append("    institutionName: ").append(this.toIndentedString(this.institutionName)).append("\n");
        sb.append("    institutionId: ").append(this.toIndentedString(this.institutionId)).append("\n");
        sb.append("    dateCreated: ").append(this.toIndentedString(this.dateCreated)).append("\n");
        sb.append("    dateCompleted: ").append(this.toIndentedString(this.dateCompleted)).append("\n");
        sb.append("    requestId: ").append(this.toIndentedString(this.requestId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum SwitchMethodEnum {
        INSTANT("instant"),
        MAIL("mail"),
        PDF("pdf"),
        NULL("null");

        private String value;

        private SwitchMethodEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static SwitchMethodEnum fromValue(String value) {
            for (SwitchMethodEnum b : SwitchMethodEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<SwitchMethodEnum> {
            public void write(JsonWriter jsonWriter, SwitchMethodEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public SwitchMethodEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return SwitchMethodEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StateEnum {
        INITIALIZED("initialized"),
        PROCESSING("processing"),
        COMPLETED("completed"),
        ERROR("error");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StateEnum fromValue(String value) {
            for (StateEnum b : StateEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<StateEnum> {
            public void write(JsonWriter jsonWriter, StateEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StateEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StateEnum.fromValue(value);
            }
        }
    }
}

