/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.WebhookEnvironmentValues;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Fired when the status of a deposit switch request has changed.")
public class DepositSwitchStateUpdateWebhook {
    public static final String SERIALIZED_NAME_WEBHOOK_TYPE = "webhook_type";
    @SerializedName(value="webhook_type")
    private String webhookType;
    public static final String SERIALIZED_NAME_WEBHOOK_CODE = "webhook_code";
    @SerializedName(value="webhook_code")
    private String webhookCode;
    public static final String SERIALIZED_NAME_STATE = "state";
    @SerializedName(value="state")
    private String state;
    public static final String SERIALIZED_NAME_DEPOSIT_SWITCH_ID = "deposit_switch_id";
    @SerializedName(value="deposit_switch_id")
    private String depositSwitchId;
    public static final String SERIALIZED_NAME_ENVIRONMENT = "environment";
    @SerializedName(value="environment")
    private WebhookEnvironmentValues environment;

    public DepositSwitchStateUpdateWebhook webhookType(String webhookType) {
        this.webhookType = webhookType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="`\"DEPOSIT_SWITCH\"`")
    public String getWebhookType() {
        return this.webhookType;
    }

    public void setWebhookType(String webhookType) {
        this.webhookType = webhookType;
    }

    public DepositSwitchStateUpdateWebhook webhookCode(String webhookCode) {
        this.webhookCode = webhookCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="`\"SWITCH_STATE_UPDATE\"`")
    public String getWebhookCode() {
        return this.webhookCode;
    }

    public void setWebhookCode(String webhookCode) {
        this.webhookCode = webhookCode;
    }

    public DepositSwitchStateUpdateWebhook state(String state) {
        this.state = state;
        return this;
    }

    @Nullable
    @ApiModelProperty(value=" The state, or status, of the deposit switch.  `initialized`: The deposit switch has been initialized with the user entering the information required to submit the deposit switch request.  `processing`: The deposit switch request has been submitted and is being processed.  `completed`: The user's employer has fulfilled and completed the deposit switch request.  `error`: There was an error processing the deposit switch request.  For more information, see the [Deposit Switch API reference](/docs/deposit-switch/reference#deposit_switchget).")
    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public DepositSwitchStateUpdateWebhook depositSwitchId(String depositSwitchId) {
        this.depositSwitchId = depositSwitchId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The ID of the deposit switch.")
    public String getDepositSwitchId() {
        return this.depositSwitchId;
    }

    public void setDepositSwitchId(String depositSwitchId) {
        this.depositSwitchId = depositSwitchId;
    }

    public DepositSwitchStateUpdateWebhook environment(WebhookEnvironmentValues environment) {
        this.environment = environment;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public WebhookEnvironmentValues getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(WebhookEnvironmentValues environment) {
        this.environment = environment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DepositSwitchStateUpdateWebhook depositSwitchStateUpdateWebhook = (DepositSwitchStateUpdateWebhook)o;
        return Objects.equals(this.webhookType, depositSwitchStateUpdateWebhook.webhookType) && Objects.equals(this.webhookCode, depositSwitchStateUpdateWebhook.webhookCode) && Objects.equals(this.state, depositSwitchStateUpdateWebhook.state) && Objects.equals(this.depositSwitchId, depositSwitchStateUpdateWebhook.depositSwitchId) && Objects.equals((Object)this.environment, (Object)depositSwitchStateUpdateWebhook.environment);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.webhookType, this.webhookCode, this.state, this.depositSwitchId, this.environment});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DepositSwitchStateUpdateWebhook {\n");
        sb.append("    webhookType: ").append(this.toIndentedString(this.webhookType)).append("\n");
        sb.append("    webhookCode: ").append(this.toIndentedString(this.webhookCode)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    depositSwitchId: ").append(this.toIndentedString(this.depositSwitchId)).append("\n");
        sb.append("    environment: ").append(this.toIndentedString((Object)this.environment)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

