/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

@ApiModel(description="The deposit switch destination account")
public class DepositSwitchTargetAccount {
    public static final String SERIALIZED_NAME_ACCOUNT_NUMBER = "account_number";
    @SerializedName(value="account_number")
    private String accountNumber;
    public static final String SERIALIZED_NAME_ROUTING_NUMBER = "routing_number";
    @SerializedName(value="routing_number")
    private String routingNumber;
    public static final String SERIALIZED_NAME_ACCOUNT_NAME = "account_name";
    @SerializedName(value="account_name")
    private String accountName;
    public static final String SERIALIZED_NAME_ACCOUNT_SUBTYPE = "account_subtype";
    @SerializedName(value="account_subtype")
    private AccountSubtypeEnum accountSubtype;

    public DepositSwitchTargetAccount accountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
        return this;
    }

    @ApiModelProperty(required=true, value="Account number for deposit switch destination")
    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public DepositSwitchTargetAccount routingNumber(String routingNumber) {
        this.routingNumber = routingNumber;
        return this;
    }

    @ApiModelProperty(required=true, value="Routing number for deposit switch destination")
    public String getRoutingNumber() {
        return this.routingNumber;
    }

    public void setRoutingNumber(String routingNumber) {
        this.routingNumber = routingNumber;
    }

    public DepositSwitchTargetAccount accountName(String accountName) {
        this.accountName = accountName;
        return this;
    }

    @ApiModelProperty(required=true, value="The name of the deposit switch destination account, as it will be displayed to the end user in the Deposit Switch interface. It is not required to match the name used in online banking.")
    public String getAccountName() {
        return this.accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public DepositSwitchTargetAccount accountSubtype(AccountSubtypeEnum accountSubtype) {
        this.accountSubtype = accountSubtype;
        return this;
    }

    @ApiModelProperty(required=true, value="The account subtype of the account, either `checking` or `savings`.")
    public AccountSubtypeEnum getAccountSubtype() {
        return this.accountSubtype;
    }

    public void setAccountSubtype(AccountSubtypeEnum accountSubtype) {
        this.accountSubtype = accountSubtype;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DepositSwitchTargetAccount depositSwitchTargetAccount = (DepositSwitchTargetAccount)o;
        return Objects.equals(this.accountNumber, depositSwitchTargetAccount.accountNumber) && Objects.equals(this.routingNumber, depositSwitchTargetAccount.routingNumber) && Objects.equals(this.accountName, depositSwitchTargetAccount.accountName) && Objects.equals((Object)this.accountSubtype, (Object)depositSwitchTargetAccount.accountSubtype);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.accountNumber, this.routingNumber, this.accountName, this.accountSubtype});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DepositSwitchTargetAccount {\n");
        sb.append("    accountNumber: ").append(this.toIndentedString(this.accountNumber)).append("\n");
        sb.append("    routingNumber: ").append(this.toIndentedString(this.routingNumber)).append("\n");
        sb.append("    accountName: ").append(this.toIndentedString(this.accountName)).append("\n");
        sb.append("    accountSubtype: ").append(this.toIndentedString((Object)this.accountSubtype)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum AccountSubtypeEnum {
        CHECKING("checking"),
        SAVINGS("savings");

        private String value;

        private AccountSubtypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static AccountSubtypeEnum fromValue(String value) {
            for (AccountSubtypeEnum b : AccountSubtypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<AccountSubtypeEnum> {
            public void write(JsonWriter jsonWriter, AccountSubtypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public AccountSubtypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return AccountSubtypeEnum.fromValue(value);
            }
        }
    }
}

