/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.DepositSwitchAddressData;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The deposit switch target user")
public class DepositSwitchTargetUser {
    public static final String SERIALIZED_NAME_GIVEN_NAME = "given_name";
    @SerializedName(value="given_name")
    private String givenName;
    public static final String SERIALIZED_NAME_FAMILY_NAME = "family_name";
    @SerializedName(value="family_name")
    private String familyName;
    public static final String SERIALIZED_NAME_PHONE = "phone";
    @SerializedName(value="phone")
    private String phone;
    public static final String SERIALIZED_NAME_EMAIL = "email";
    @SerializedName(value="email")
    private String email;
    public static final String SERIALIZED_NAME_ADDRESS = "address";
    @SerializedName(value="address")
    private DepositSwitchAddressData address;
    public static final String SERIALIZED_NAME_TAX_PAYER_ID = "tax_payer_id";
    @SerializedName(value="tax_payer_id")
    private String taxPayerId;

    public DepositSwitchTargetUser givenName(String givenName) {
        this.givenName = givenName;
        return this;
    }

    @ApiModelProperty(required=true, value="The given name (first name) of the user.")
    public String getGivenName() {
        return this.givenName;
    }

    public void setGivenName(String givenName) {
        this.givenName = givenName;
    }

    public DepositSwitchTargetUser familyName(String familyName) {
        this.familyName = familyName;
        return this;
    }

    @ApiModelProperty(required=true, value="The family name (last name) of the user.")
    public String getFamilyName() {
        return this.familyName;
    }

    public void setFamilyName(String familyName) {
        this.familyName = familyName;
    }

    public DepositSwitchTargetUser phone(String phone) {
        this.phone = phone;
        return this;
    }

    @ApiModelProperty(required=true, value="The phone number of the user. The endpoint can accept a variety of phone number formats, including E.164.")
    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public DepositSwitchTargetUser email(String email) {
        this.email = email;
        return this;
    }

    @ApiModelProperty(required=true, value="The email address of the user.")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public DepositSwitchTargetUser address(DepositSwitchAddressData address) {
        this.address = address;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public DepositSwitchAddressData getAddress() {
        return this.address;
    }

    public void setAddress(DepositSwitchAddressData address) {
        this.address = address;
    }

    public DepositSwitchTargetUser taxPayerId(String taxPayerId) {
        this.taxPayerId = taxPayerId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The taxpayer ID of the user, generally their SSN, EIN, or TIN.")
    public String getTaxPayerId() {
        return this.taxPayerId;
    }

    public void setTaxPayerId(String taxPayerId) {
        this.taxPayerId = taxPayerId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DepositSwitchTargetUser depositSwitchTargetUser = (DepositSwitchTargetUser)o;
        return Objects.equals(this.givenName, depositSwitchTargetUser.givenName) && Objects.equals(this.familyName, depositSwitchTargetUser.familyName) && Objects.equals(this.phone, depositSwitchTargetUser.phone) && Objects.equals(this.email, depositSwitchTargetUser.email) && Objects.equals(this.address, depositSwitchTargetUser.address) && Objects.equals(this.taxPayerId, depositSwitchTargetUser.taxPayerId);
    }

    public int hashCode() {
        return Objects.hash(this.givenName, this.familyName, this.phone, this.email, this.address, this.taxPayerId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DepositSwitchTargetUser {\n");
        sb.append("    givenName: ").append(this.toIndentedString(this.givenName)).append("\n");
        sb.append("    familyName: ").append(this.toIndentedString(this.familyName)).append("\n");
        sb.append("    phone: ").append(this.toIndentedString(this.phone)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    taxPayerId: ").append(this.toIndentedString(this.taxPayerId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

