/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="A possible account detected to be associated with a transaction user.")
public class DetectedAccount {
    public static final String SERIALIZED_NAME_ACCOUNT_TYPE = "account_type";
    @SerializedName(value="account_type")
    private String accountType;
    public static final String SERIALIZED_NAME_ACCOUNT_SUBTYPE = "account_subtype";
    @SerializedName(value="account_subtype")
    private String accountSubtype;
    public static final String SERIALIZED_NAME_TRANSACTION_COUNT = "transaction_count";
    @SerializedName(value="transaction_count")
    private Integer transactionCount;
    public static final String SERIALIZED_NAME_OLDEST_TRANSACTION_DATE = "oldest_transaction_date";
    @SerializedName(value="oldest_transaction_date")
    private LocalDate oldestTransactionDate;
    public static final String SERIALIZED_NAME_NEWEST_TRANSACTION_DATE = "newest_transaction_date";
    @SerializedName(value="newest_transaction_date")
    private LocalDate newestTransactionDate;
    public static final String SERIALIZED_NAME_NEWEST_TRANSACTION_AMOUNT = "newest_transaction_amount";
    @SerializedName(value="newest_transaction_amount")
    private Double newestTransactionAmount;
    public static final String SERIALIZED_NAME_TOTAL_OUTFLOWS = "total_outflows";
    @SerializedName(value="total_outflows")
    private Double totalOutflows;
    public static final String SERIALIZED_NAME_TOTAL_INFLOWS = "total_inflows";
    @SerializedName(value="total_inflows")
    private Double totalInflows;

    public DetectedAccount accountType(String accountType) {
        this.accountType = accountType;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The detected account type (depository, credit, loan, investment etc.).")
    public String getAccountType() {
        return this.accountType;
    }

    public void setAccountType(String accountType) {
        this.accountType = accountType;
    }

    public DetectedAccount accountSubtype(String accountSubtype) {
        this.accountSubtype = accountSubtype;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The detected subtype of the account, based on the transactions to/from the institution.")
    public String getAccountSubtype() {
        return this.accountSubtype;
    }

    public void setAccountSubtype(String accountSubtype) {
        this.accountSubtype = accountSubtype;
    }

    public DetectedAccount transactionCount(Integer transactionCount) {
        this.transactionCount = transactionCount;
        return this;
    }

    @ApiModelProperty(required=true, value="The number of transactions associated with this detected account type at this financial institution.")
    public Integer getTransactionCount() {
        return this.transactionCount;
    }

    public void setTransactionCount(Integer transactionCount) {
        this.transactionCount = transactionCount;
    }

    public DetectedAccount oldestTransactionDate(LocalDate oldestTransactionDate) {
        this.oldestTransactionDate = oldestTransactionDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The date of the oldest transaction associated with this detected account type at this financial institution.")
    public LocalDate getOldestTransactionDate() {
        return this.oldestTransactionDate;
    }

    public void setOldestTransactionDate(LocalDate oldestTransactionDate) {
        this.oldestTransactionDate = oldestTransactionDate;
    }

    public DetectedAccount newestTransactionDate(LocalDate newestTransactionDate) {
        this.newestTransactionDate = newestTransactionDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The date of the newest transaction associated with this detected account type at this financial institution.")
    public LocalDate getNewestTransactionDate() {
        return this.newestTransactionDate;
    }

    public void setNewestTransactionDate(LocalDate newestTransactionDate) {
        this.newestTransactionDate = newestTransactionDate;
    }

    public DetectedAccount newestTransactionAmount(Double newestTransactionAmount) {
        this.newestTransactionAmount = newestTransactionAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Amount of the most recent transaction associated with this detected account type at this financial institution.")
    public Double getNewestTransactionAmount() {
        return this.newestTransactionAmount;
    }

    public void setNewestTransactionAmount(Double newestTransactionAmount) {
        this.newestTransactionAmount = newestTransactionAmount;
    }

    public DetectedAccount totalOutflows(Double totalOutflows) {
        this.totalOutflows = totalOutflows;
        return this;
    }

    @ApiModelProperty(required=true, value="Sum of outflow amounts associated with this detected account type at this financial institution.")
    public Double getTotalOutflows() {
        return this.totalOutflows;
    }

    public void setTotalOutflows(Double totalOutflows) {
        this.totalOutflows = totalOutflows;
    }

    public DetectedAccount totalInflows(Double totalInflows) {
        this.totalInflows = totalInflows;
        return this;
    }

    @ApiModelProperty(required=true, value="Sum of inflow amounts associated with this detected account type at this financial institution.")
    public Double getTotalInflows() {
        return this.totalInflows;
    }

    public void setTotalInflows(Double totalInflows) {
        this.totalInflows = totalInflows;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DetectedAccount detectedAccount = (DetectedAccount)o;
        return Objects.equals(this.accountType, detectedAccount.accountType) && Objects.equals(this.accountSubtype, detectedAccount.accountSubtype) && Objects.equals(this.transactionCount, detectedAccount.transactionCount) && Objects.equals(this.oldestTransactionDate, detectedAccount.oldestTransactionDate) && Objects.equals(this.newestTransactionDate, detectedAccount.newestTransactionDate) && Objects.equals(this.newestTransactionAmount, detectedAccount.newestTransactionAmount) && Objects.equals(this.totalOutflows, detectedAccount.totalOutflows) && Objects.equals(this.totalInflows, detectedAccount.totalInflows);
    }

    public int hashCode() {
        return Objects.hash(this.accountType, this.accountSubtype, this.transactionCount, this.oldestTransactionDate, this.newestTransactionDate, this.newestTransactionAmount, this.totalOutflows, this.totalInflows);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DetectedAccount {\n");
        sb.append("    accountType: ").append(this.toIndentedString(this.accountType)).append("\n");
        sb.append("    accountSubtype: ").append(this.toIndentedString(this.accountSubtype)).append("\n");
        sb.append("    transactionCount: ").append(this.toIndentedString(this.transactionCount)).append("\n");
        sb.append("    oldestTransactionDate: ").append(this.toIndentedString(this.oldestTransactionDate)).append("\n");
        sb.append("    newestTransactionDate: ").append(this.toIndentedString(this.newestTransactionDate)).append("\n");
        sb.append("    newestTransactionAmount: ").append(this.toIndentedString(this.newestTransactionAmount)).append("\n");
        sb.append("    totalOutflows: ").append(this.toIndentedString(this.totalOutflows)).append("\n");
        sb.append("    totalInflows: ").append(this.toIndentedString(this.totalInflows)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

