/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.DocumentAuthenticityMatchCode;
import com.plaid.client.model.ImageQuality;
import com.plaid.client.model.PhysicalDocumentExtractedDataAnalysis;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="High level descriptions of how the associated document was processed. If a document fails verification, the details in the `analysis` object should help clarify why the document was rejected.")
public class DocumentAnalysis {
    public static final String SERIALIZED_NAME_AUTHENTICITY = "authenticity";
    @SerializedName(value="authenticity")
    private DocumentAuthenticityMatchCode authenticity;
    public static final String SERIALIZED_NAME_IMAGE_QUALITY = "image_quality";
    @SerializedName(value="image_quality")
    private ImageQuality imageQuality;
    public static final String SERIALIZED_NAME_EXTRACTED_DATA = "extracted_data";
    @SerializedName(value="extracted_data")
    private PhysicalDocumentExtractedDataAnalysis extractedData;

    public DocumentAnalysis authenticity(DocumentAuthenticityMatchCode authenticity) {
        this.authenticity = authenticity;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public DocumentAuthenticityMatchCode getAuthenticity() {
        return this.authenticity;
    }

    public void setAuthenticity(DocumentAuthenticityMatchCode authenticity) {
        this.authenticity = authenticity;
    }

    public DocumentAnalysis imageQuality(ImageQuality imageQuality) {
        this.imageQuality = imageQuality;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public ImageQuality getImageQuality() {
        return this.imageQuality;
    }

    public void setImageQuality(ImageQuality imageQuality) {
        this.imageQuality = imageQuality;
    }

    public DocumentAnalysis extractedData(PhysicalDocumentExtractedDataAnalysis extractedData) {
        this.extractedData = extractedData;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="")
    public PhysicalDocumentExtractedDataAnalysis getExtractedData() {
        return this.extractedData;
    }

    public void setExtractedData(PhysicalDocumentExtractedDataAnalysis extractedData) {
        this.extractedData = extractedData;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentAnalysis documentAnalysis = (DocumentAnalysis)o;
        return Objects.equals((Object)this.authenticity, (Object)documentAnalysis.authenticity) && Objects.equals((Object)this.imageQuality, (Object)documentAnalysis.imageQuality) && Objects.equals(this.extractedData, documentAnalysis.extractedData);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.authenticity, this.imageQuality, this.extractedData});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DocumentAnalysis {\n");
        sb.append("    authenticity: ").append(this.toIndentedString((Object)this.authenticity)).append("\n");
        sb.append("    imageQuality: ").append(this.toIndentedString((Object)this.imageQuality)).append("\n");
        sb.append("    extractedData: ").append(this.toIndentedString(this.extractedData)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

