/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.DocType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="An object representing metadata from the end user's uploaded document.")
public class DocumentMetadata {
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private String status;
    public static final String SERIALIZED_NAME_DOC_ID = "doc_id";
    @SerializedName(value="doc_id")
    private String docId;
    public static final String SERIALIZED_NAME_DOC_TYPE = "doc_type";
    @SerializedName(value="doc_type")
    private DocType docType;

    public DocumentMetadata name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of the document.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DocumentMetadata status(String status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The processing status of the document.  `PROCESSING_COMPLETE`: The document was successfully processed.  `DOCUMENT_ERROR`: The document could not be processed. Possible causes include: The document was an unacceptable document type such as an offer letter or bank statement, the document image was cropped or blurry, or the document was corrupted.  `UNKNOWN` or `null`: An internal error occurred. If this happens repeatedly, contact support or your Plaid account manager.")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public DocumentMetadata docId(String docId) {
        this.docId = docId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="An identifier of the document that is also present in the paystub response.")
    public String getDocId() {
        return this.docId;
    }

    public void setDocId(String docId) {
        this.docId = docId;
    }

    public DocumentMetadata docType(DocType docType) {
        this.docType = docType;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public DocType getDocType() {
        return this.docType;
    }

    public void setDocType(DocType docType) {
        this.docType = docType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentMetadata documentMetadata = (DocumentMetadata)o;
        return Objects.equals(this.name, documentMetadata.name) && Objects.equals(this.status, documentMetadata.status) && Objects.equals(this.docId, documentMetadata.docId) && Objects.equals((Object)this.docType, (Object)documentMetadata.docType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.status, this.docId, this.docType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DocumentMetadata {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    docId: ").append(this.toIndentedString(this.docId)).append("\n");
        sb.append("    docType: ").append(this.toIndentedString((Object)this.docType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

