/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.DocumentRiskSignalInstitutionMetadata;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Details about a certain reason as to why a document could potentially be fraudulent.")
public class DocumentRiskSignal {
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private String type;
    public static final String SERIALIZED_NAME_FIELD = "field";
    @SerializedName(value="field")
    private String field;
    public static final String SERIALIZED_NAME_HAS_FRAUD_RISK = "has_fraud_risk";
    @SerializedName(value="has_fraud_risk")
    private Boolean hasFraudRisk;
    public static final String SERIALIZED_NAME_INSTITUTION_METADATA = "institution_metadata";
    @SerializedName(value="institution_metadata")
    private DocumentRiskSignalInstitutionMetadata institutionMetadata;
    public static final String SERIALIZED_NAME_EXPECTED_VALUE = "expected_value";
    @SerializedName(value="expected_value")
    private String expectedValue;
    public static final String SERIALIZED_NAME_ACTUAL_VALUE = "actual_value";
    @SerializedName(value="actual_value")
    private String actualValue;
    public static final String SERIALIZED_NAME_SIGNAL_DESCRIPTION = "signal_description";
    @SerializedName(value="signal_description")
    private String signalDescription;
    public static final String SERIALIZED_NAME_PAGE_NUMBER = "page_number";
    @SerializedName(value="page_number")
    private Integer pageNumber;

    public DocumentRiskSignal type(String type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The result from the risk signal check.")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public DocumentRiskSignal field(String field) {
        this.field = field;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The field which the risk signal was computed for")
    public String getField() {
        return this.field;
    }

    public void setField(String field) {
        this.field = field;
    }

    public DocumentRiskSignal hasFraudRisk(Boolean hasFraudRisk) {
        this.hasFraudRisk = hasFraudRisk;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="A flag used to quickly identify if the signal indicates that this field is authentic or fraudulent")
    public Boolean getHasFraudRisk() {
        return this.hasFraudRisk;
    }

    public void setHasFraudRisk(Boolean hasFraudRisk) {
        this.hasFraudRisk = hasFraudRisk;
    }

    public DocumentRiskSignal institutionMetadata(DocumentRiskSignalInstitutionMetadata institutionMetadata) {
        this.institutionMetadata = institutionMetadata;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="")
    public DocumentRiskSignalInstitutionMetadata getInstitutionMetadata() {
        return this.institutionMetadata;
    }

    public void setInstitutionMetadata(DocumentRiskSignalInstitutionMetadata institutionMetadata) {
        this.institutionMetadata = institutionMetadata;
    }

    public DocumentRiskSignal expectedValue(String expectedValue) {
        this.expectedValue = expectedValue;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The expected value of the field, as seen on the document")
    public String getExpectedValue() {
        return this.expectedValue;
    }

    public void setExpectedValue(String expectedValue) {
        this.expectedValue = expectedValue;
    }

    public DocumentRiskSignal actualValue(String actualValue) {
        this.actualValue = actualValue;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The derived value obtained in the risk signal calculation process for this field")
    public String getActualValue() {
        return this.actualValue;
    }

    public void setActualValue(String actualValue) {
        this.actualValue = actualValue;
    }

    public DocumentRiskSignal signalDescription(String signalDescription) {
        this.signalDescription = signalDescription;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="A human-readable explanation providing more detail into the particular risk signal")
    public String getSignalDescription() {
        return this.signalDescription;
    }

    public void setSignalDescription(String signalDescription) {
        this.signalDescription = signalDescription;
    }

    public DocumentRiskSignal pageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The relevant page associated with the risk signal")
    public Integer getPageNumber() {
        return this.pageNumber;
    }

    public void setPageNumber(Integer pageNumber) {
        this.pageNumber = pageNumber;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentRiskSignal documentRiskSignal = (DocumentRiskSignal)o;
        return Objects.equals(this.type, documentRiskSignal.type) && Objects.equals(this.field, documentRiskSignal.field) && Objects.equals(this.hasFraudRisk, documentRiskSignal.hasFraudRisk) && Objects.equals(this.institutionMetadata, documentRiskSignal.institutionMetadata) && Objects.equals(this.expectedValue, documentRiskSignal.expectedValue) && Objects.equals(this.actualValue, documentRiskSignal.actualValue) && Objects.equals(this.signalDescription, documentRiskSignal.signalDescription) && Objects.equals(this.pageNumber, documentRiskSignal.pageNumber);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.field, this.hasFraudRisk, this.institutionMetadata, this.expectedValue, this.actualValue, this.signalDescription, this.pageNumber);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DocumentRiskSignal {\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("    field: ").append(this.toIndentedString(this.field)).append("\n");
        sb.append("    hasFraudRisk: ").append(this.toIndentedString(this.hasFraudRisk)).append("\n");
        sb.append("    institutionMetadata: ").append(this.toIndentedString(this.institutionMetadata)).append("\n");
        sb.append("    expectedValue: ").append(this.toIndentedString(this.expectedValue)).append("\n");
        sb.append("    actualValue: ").append(this.toIndentedString(this.actualValue)).append("\n");
        sb.append("    signalDescription: ").append(this.toIndentedString(this.signalDescription)).append("\n");
        sb.append("    pageNumber: ").append(this.toIndentedString(this.pageNumber)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

