/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.MultiDocumentRiskSignal;
import com.plaid.client.model.SingleDocumentRiskSignal;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Object containing fraud risk data for a set of income documents.")
public class DocumentRiskSignalsObject {
    public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
    @SerializedName(value="account_id")
    private String accountId;
    public static final String SERIALIZED_NAME_SINGLE_DOCUMENT_RISK_SIGNALS = "single_document_risk_signals";
    @SerializedName(value="single_document_risk_signals")
    private List<SingleDocumentRiskSignal> singleDocumentRiskSignals = new ArrayList<SingleDocumentRiskSignal>();
    public static final String SERIALIZED_NAME_MULTI_DOCUMENT_RISK_SIGNALS = "multi_document_risk_signals";
    @SerializedName(value="multi_document_risk_signals")
    private List<MultiDocumentRiskSignal> multiDocumentRiskSignals = new ArrayList<MultiDocumentRiskSignal>();

    public DocumentRiskSignalsObject accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="ID of the payroll provider account.")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public DocumentRiskSignalsObject singleDocumentRiskSignals(List<SingleDocumentRiskSignal> singleDocumentRiskSignals) {
        this.singleDocumentRiskSignals = singleDocumentRiskSignals;
        return this;
    }

    public DocumentRiskSignalsObject addSingleDocumentRiskSignalsItem(SingleDocumentRiskSignal singleDocumentRiskSignalsItem) {
        this.singleDocumentRiskSignals.add(singleDocumentRiskSignalsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Array of document metadata and associated risk signals per document")
    public List<SingleDocumentRiskSignal> getSingleDocumentRiskSignals() {
        return this.singleDocumentRiskSignals;
    }

    public void setSingleDocumentRiskSignals(List<SingleDocumentRiskSignal> singleDocumentRiskSignals) {
        this.singleDocumentRiskSignals = singleDocumentRiskSignals;
    }

    public DocumentRiskSignalsObject multiDocumentRiskSignals(List<MultiDocumentRiskSignal> multiDocumentRiskSignals) {
        this.multiDocumentRiskSignals = multiDocumentRiskSignals;
        return this;
    }

    public DocumentRiskSignalsObject addMultiDocumentRiskSignalsItem(MultiDocumentRiskSignal multiDocumentRiskSignalsItem) {
        this.multiDocumentRiskSignals.add(multiDocumentRiskSignalsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Array of risk signals computed from a set of uploaded documents and the associated documents' metadata")
    public List<MultiDocumentRiskSignal> getMultiDocumentRiskSignals() {
        return this.multiDocumentRiskSignals;
    }

    public void setMultiDocumentRiskSignals(List<MultiDocumentRiskSignal> multiDocumentRiskSignals) {
        this.multiDocumentRiskSignals = multiDocumentRiskSignals;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentRiskSignalsObject documentRiskSignalsObject = (DocumentRiskSignalsObject)o;
        return Objects.equals(this.accountId, documentRiskSignalsObject.accountId) && Objects.equals(this.singleDocumentRiskSignals, documentRiskSignalsObject.singleDocumentRiskSignals) && Objects.equals(this.multiDocumentRiskSignals, documentRiskSignalsObject.multiDocumentRiskSignals);
    }

    public int hashCode() {
        return Objects.hash(this.accountId, this.singleDocumentRiskSignals, this.multiDocumentRiskSignals);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DocumentRiskSignalsObject {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    singleDocumentRiskSignals: ").append(this.toIndentedString(this.singleDocumentRiskSignals)).append("\n");
        sb.append("    multiDocumentRiskSignals: ").append(this.toIndentedString(this.multiDocumentRiskSignals)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

