/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="A summary across all risk signals associated with a document")
public class DocumentRiskSummary {
    public static final String SERIALIZED_NAME_RISK_SCORE = "risk_score";
    @SerializedName(value="risk_score")
    private Double riskScore;

    public DocumentRiskSummary riskScore(Double riskScore) {
        this.riskScore = riskScore;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="A number between 0 and 100, inclusive, where a score closer to 0 indicates a document is likely to be trustworthy and a score closer to 100 indicates a document is likely to be fraudulent")
    public Double getRiskScore() {
        return this.riskScore;
    }

    public void setRiskScore(Double riskScore) {
        this.riskScore = riskScore;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentRiskSummary documentRiskSummary = (DocumentRiskSummary)o;
        return Objects.equals(this.riskScore, documentRiskSummary.riskScore);
    }

    public int hashCode() {
        return Objects.hash(this.riskScore);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DocumentRiskSummary {\n");
        sb.append("    riskScore: ").append(this.toIndentedString(this.riskScore)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

