/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.DocumentaryVerificationDocument;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Data, images, analysis, and results from the `documentary_verification` step. This field will be `null` unless `steps.documentary_verification` has reached a terminal state of either `success` or `failed`.")
public class DocumentaryVerification {
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private String status;
    public static final String SERIALIZED_NAME_DOCUMENTS = "documents";
    @SerializedName(value="documents")
    private List<DocumentaryVerificationDocument> documents = new ArrayList<DocumentaryVerificationDocument>();

    public DocumentaryVerification status(String status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(example="success", required=true, value="The outcome status for the associated Identity Verification attempt's `documentary_verification` step. This field will always have the same value as `steps.documentary_verification`.")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public DocumentaryVerification documents(List<DocumentaryVerificationDocument> documents) {
        this.documents = documents;
        return this;
    }

    public DocumentaryVerification addDocumentsItem(DocumentaryVerificationDocument documentsItem) {
        this.documents.add(documentsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="An array of documents submitted to the `documentary_verification` step. Each entry represents one user submission, where each submission will contain both a front and back image, or just a front image, depending on the document type.  Note: Plaid will automatically let a user submit a new set of document images up to three times if we detect that a previous attempt might have failed due to user error. For example, if the first set of document images are blurry or obscured by glare, the user will be asked to capture their documents again, resulting in at least two separate entries within `documents`. If the overall `documentary_verification` is `failed`, the user has exhausted their retry attempts.")
    public List<DocumentaryVerificationDocument> getDocuments() {
        return this.documents;
    }

    public void setDocuments(List<DocumentaryVerificationDocument> documents) {
        this.documents = documents;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentaryVerification documentaryVerification = (DocumentaryVerification)o;
        return Objects.equals(this.status, documentaryVerification.status) && Objects.equals(this.documents, documentaryVerification.documents);
    }

    public int hashCode() {
        return Objects.hash(this.status, this.documents);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DocumentaryVerification {\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    documents: ").append(this.toIndentedString(this.documents)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

