/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.DocumentAnalysis;
import com.plaid.client.model.DocumentStatus;
import com.plaid.client.model.PhysicalDocumentExtractedData;
import com.plaid.client.model.PhysicalDocumentImages;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Images, extracted data, and analysis from a user's identity document")
public class DocumentaryVerificationDocument {
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private DocumentStatus status;
    public static final String SERIALIZED_NAME_ATTEMPT = "attempt";
    @SerializedName(value="attempt")
    private Integer attempt;
    public static final String SERIALIZED_NAME_IMAGES = "images";
    @SerializedName(value="images")
    private PhysicalDocumentImages images;
    public static final String SERIALIZED_NAME_EXTRACTED_DATA = "extracted_data";
    @SerializedName(value="extracted_data")
    private PhysicalDocumentExtractedData extractedData;
    public static final String SERIALIZED_NAME_ANALYSIS = "analysis";
    @SerializedName(value="analysis")
    private DocumentAnalysis analysis;
    public static final String SERIALIZED_NAME_REDACTED_AT = "redacted_at";
    @SerializedName(value="redacted_at")
    private OffsetDateTime redactedAt;

    public DocumentaryVerificationDocument status(DocumentStatus status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public DocumentStatus getStatus() {
        return this.status;
    }

    public void setStatus(DocumentStatus status) {
        this.status = status;
    }

    public DocumentaryVerificationDocument attempt(Integer attempt) {
        this.attempt = attempt;
        return this;
    }

    @ApiModelProperty(example="1", required=true, value="The `attempt` field begins with 1 and increments with each subsequent document upload.")
    public Integer getAttempt() {
        return this.attempt;
    }

    public void setAttempt(Integer attempt) {
        this.attempt = attempt;
    }

    public DocumentaryVerificationDocument images(PhysicalDocumentImages images) {
        this.images = images;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public PhysicalDocumentImages getImages() {
        return this.images;
    }

    public void setImages(PhysicalDocumentImages images) {
        this.images = images;
    }

    public DocumentaryVerificationDocument extractedData(PhysicalDocumentExtractedData extractedData) {
        this.extractedData = extractedData;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="")
    public PhysicalDocumentExtractedData getExtractedData() {
        return this.extractedData;
    }

    public void setExtractedData(PhysicalDocumentExtractedData extractedData) {
        this.extractedData = extractedData;
    }

    public DocumentaryVerificationDocument analysis(DocumentAnalysis analysis) {
        this.analysis = analysis;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public DocumentAnalysis getAnalysis() {
        return this.analysis;
    }

    public void setAnalysis(DocumentAnalysis analysis) {
        this.analysis = analysis;
    }

    public DocumentaryVerificationDocument redactedAt(OffsetDateTime redactedAt) {
        this.redactedAt = redactedAt;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2020-07-24T03:26:02Z", required=true, value="An ISO8601 formatted timestamp.")
    public OffsetDateTime getRedactedAt() {
        return this.redactedAt;
    }

    public void setRedactedAt(OffsetDateTime redactedAt) {
        this.redactedAt = redactedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DocumentaryVerificationDocument documentaryVerificationDocument = (DocumentaryVerificationDocument)o;
        return Objects.equals((Object)this.status, (Object)documentaryVerificationDocument.status) && Objects.equals(this.attempt, documentaryVerificationDocument.attempt) && Objects.equals(this.images, documentaryVerificationDocument.images) && Objects.equals(this.extractedData, documentaryVerificationDocument.extractedData) && Objects.equals(this.analysis, documentaryVerificationDocument.analysis) && Objects.equals(this.redactedAt, documentaryVerificationDocument.redactedAt);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.status, this.attempt, this.images, this.extractedData, this.analysis, this.redactedAt});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DocumentaryVerificationDocument {\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    attempt: ").append(this.toIndentedString(this.attempt)).append("\n");
        sb.append("    images: ").append(this.toIndentedString(this.images)).append("\n");
        sb.append("    extractedData: ").append(this.toIndentedString(this.extractedData)).append("\n");
        sb.append("    analysis: ").append(this.toIndentedString(this.analysis)).append("\n");
        sb.append("    redactedAt: ").append(this.toIndentedString(this.redactedAt)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

