/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.EarningsBreakdown;
import com.plaid.client.model.EarningsTotal;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="An object representing both a breakdown of earnings on a paystub and the total earnings.")
public class Earnings {
    public static final String SERIALIZED_NAME_SUBTOTALS = "subtotals";
    @SerializedName(value="subtotals")
    private List<EarningsTotal> subtotals = null;
    public static final String SERIALIZED_NAME_TOTALS = "totals";
    @SerializedName(value="totals")
    private List<EarningsTotal> totals = null;
    public static final String SERIALIZED_NAME_BREAKDOWN = "breakdown";
    @SerializedName(value="breakdown")
    private List<EarningsBreakdown> breakdown = null;
    public static final String SERIALIZED_NAME_TOTAL = "total";
    @SerializedName(value="total")
    private EarningsTotal total;

    public Earnings subtotals(List<EarningsTotal> subtotals) {
        this.subtotals = subtotals;
        return this;
    }

    public Earnings addSubtotalsItem(EarningsTotal subtotalsItem) {
        if (this.subtotals == null) {
            this.subtotals = new ArrayList<EarningsTotal>();
        }
        this.subtotals.add(subtotalsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<EarningsTotal> getSubtotals() {
        return this.subtotals;
    }

    public void setSubtotals(List<EarningsTotal> subtotals) {
        this.subtotals = subtotals;
    }

    public Earnings totals(List<EarningsTotal> totals) {
        this.totals = totals;
        return this;
    }

    public Earnings addTotalsItem(EarningsTotal totalsItem) {
        if (this.totals == null) {
            this.totals = new ArrayList<EarningsTotal>();
        }
        this.totals.add(totalsItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<EarningsTotal> getTotals() {
        return this.totals;
    }

    public void setTotals(List<EarningsTotal> totals) {
        this.totals = totals;
    }

    public Earnings breakdown(List<EarningsBreakdown> breakdown) {
        this.breakdown = breakdown;
        return this;
    }

    public Earnings addBreakdownItem(EarningsBreakdown breakdownItem) {
        if (this.breakdown == null) {
            this.breakdown = new ArrayList<EarningsBreakdown>();
        }
        this.breakdown.add(breakdownItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public List<EarningsBreakdown> getBreakdown() {
        return this.breakdown;
    }

    public void setBreakdown(List<EarningsBreakdown> breakdown) {
        this.breakdown = breakdown;
    }

    public Earnings total(EarningsTotal total) {
        this.total = total;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public EarningsTotal getTotal() {
        return this.total;
    }

    public void setTotal(EarningsTotal total) {
        this.total = total;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Earnings earnings = (Earnings)o;
        return Objects.equals(this.subtotals, earnings.subtotals) && Objects.equals(this.totals, earnings.totals) && Objects.equals(this.breakdown, earnings.breakdown) && Objects.equals(this.total, earnings.total);
    }

    public int hashCode() {
        return Objects.hash(this.subtotals, this.totals, this.breakdown, this.total);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Earnings {\n");
        sb.append("    subtotals: ").append(this.toIndentedString(this.subtotals)).append("\n");
        sb.append("    totals: ").append(this.toIndentedString(this.totals)).append("\n");
        sb.append("    breakdown: ").append(this.toIndentedString(this.breakdown)).append("\n");
        sb.append("    total: ").append(this.toIndentedString(this.total)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

