/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.EarningsBreakdownCanonicalDescription;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="An object representing the earnings line items for the pay period.")
public class EarningsBreakdown {
    public static final String SERIALIZED_NAME_CANONICAL_DESCRIPTION = "canonical_description";
    @SerializedName(value="canonical_description")
    private EarningsBreakdownCanonicalDescription canonicalDescription;
    public static final String SERIALIZED_NAME_CURRENT_AMOUNT = "current_amount";
    @SerializedName(value="current_amount")
    private Double currentAmount;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_HOURS = "hours";
    @SerializedName(value="hours")
    private Double hours;
    public static final String SERIALIZED_NAME_ISO_CURRENCY_CODE = "iso_currency_code";
    @SerializedName(value="iso_currency_code")
    private String isoCurrencyCode;
    public static final String SERIALIZED_NAME_RATE = "rate";
    @SerializedName(value="rate")
    private Double rate;
    public static final String SERIALIZED_NAME_UNOFFICIAL_CURRENCY_CODE = "unofficial_currency_code";
    @SerializedName(value="unofficial_currency_code")
    private String unofficialCurrencyCode;
    public static final String SERIALIZED_NAME_YTD_AMOUNT = "ytd_amount";
    @SerializedName(value="ytd_amount")
    private Double ytdAmount;

    public EarningsBreakdown canonicalDescription(EarningsBreakdownCanonicalDescription canonicalDescription) {
        this.canonicalDescription = canonicalDescription;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public EarningsBreakdownCanonicalDescription getCanonicalDescription() {
        return this.canonicalDescription;
    }

    public void setCanonicalDescription(EarningsBreakdownCanonicalDescription canonicalDescription) {
        this.canonicalDescription = canonicalDescription;
    }

    public EarningsBreakdown currentAmount(Double currentAmount) {
        this.currentAmount = currentAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Raw amount of the earning line item.")
    public Double getCurrentAmount() {
        return this.currentAmount;
    }

    public void setCurrentAmount(Double currentAmount) {
        this.currentAmount = currentAmount;
    }

    public EarningsBreakdown description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Description of the earning line item.")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public EarningsBreakdown hours(Double hours) {
        this.hours = hours;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Number of hours applicable for this earning.")
    public Double getHours() {
        return this.hours;
    }

    public void setHours(Double hours) {
        this.hours = hours;
    }

    public EarningsBreakdown isoCurrencyCode(String isoCurrencyCode) {
        this.isoCurrencyCode = isoCurrencyCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The ISO-4217 currency code of the line item. Always `null` if `unofficial_currency_code` is non-null.")
    public String getIsoCurrencyCode() {
        return this.isoCurrencyCode;
    }

    public void setIsoCurrencyCode(String isoCurrencyCode) {
        this.isoCurrencyCode = isoCurrencyCode;
    }

    public EarningsBreakdown rate(Double rate) {
        this.rate = rate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Hourly rate applicable for this earning.")
    public Double getRate() {
        return this.rate;
    }

    public void setRate(Double rate) {
        this.rate = rate;
    }

    public EarningsBreakdown unofficialCurrencyCode(String unofficialCurrencyCode) {
        this.unofficialCurrencyCode = unofficialCurrencyCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The unofficial currency code associated with the line item. Always `null` if `iso_currency_code` is non-`null`. Unofficial currency codes are used for currencies that do not have official ISO currency codes, such as cryptocurrencies and the currencies of certain countries.  See the [currency code schema](https://plaid.com/docs/api/accounts#currency-code-schema) for a full listing of supported `iso_currency_code`s.")
    public String getUnofficialCurrencyCode() {
        return this.unofficialCurrencyCode;
    }

    public void setUnofficialCurrencyCode(String unofficialCurrencyCode) {
        this.unofficialCurrencyCode = unofficialCurrencyCode;
    }

    public EarningsBreakdown ytdAmount(Double ytdAmount) {
        this.ytdAmount = ytdAmount;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The year-to-date amount of the deduction.")
    public Double getYtdAmount() {
        return this.ytdAmount;
    }

    public void setYtdAmount(Double ytdAmount) {
        this.ytdAmount = ytdAmount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EarningsBreakdown earningsBreakdown = (EarningsBreakdown)o;
        return Objects.equals((Object)this.canonicalDescription, (Object)earningsBreakdown.canonicalDescription) && Objects.equals(this.currentAmount, earningsBreakdown.currentAmount) && Objects.equals(this.description, earningsBreakdown.description) && Objects.equals(this.hours, earningsBreakdown.hours) && Objects.equals(this.isoCurrencyCode, earningsBreakdown.isoCurrencyCode) && Objects.equals(this.rate, earningsBreakdown.rate) && Objects.equals(this.unofficialCurrencyCode, earningsBreakdown.unofficialCurrencyCode) && Objects.equals(this.ytdAmount, earningsBreakdown.ytdAmount);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.canonicalDescription, this.currentAmount, this.description, this.hours, this.isoCurrencyCode, this.rate, this.unofficialCurrencyCode, this.ytdAmount});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EarningsBreakdown {\n");
        sb.append("    canonicalDescription: ").append(this.toIndentedString((Object)this.canonicalDescription)).append("\n");
        sb.append("    currentAmount: ").append(this.toIndentedString(this.currentAmount)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    hours: ").append(this.toIndentedString(this.hours)).append("\n");
        sb.append("    isoCurrencyCode: ").append(this.toIndentedString(this.isoCurrencyCode)).append("\n");
        sb.append("    rate: ").append(this.toIndentedString(this.rate)).append("\n");
        sb.append("    unofficialCurrencyCode: ").append(this.toIndentedString(this.unofficialCurrencyCode)).append("\n");
        sb.append("    ytdAmount: ").append(this.toIndentedString(this.ytdAmount)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

