/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.AddressDataNullable;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Data about the employer.")
public class Employer {
    public static final String SERIALIZED_NAME_EMPLOYER_ID = "employer_id";
    @SerializedName(value="employer_id")
    private String employerId;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_ADDRESS = "address";
    @SerializedName(value="address")
    private AddressDataNullable address;
    public static final String SERIALIZED_NAME_CONFIDENCE_SCORE = "confidence_score";
    @SerializedName(value="confidence_score")
    private Double confidenceScore;

    public Employer employerId(String employerId) {
        this.employerId = employerId;
        return this;
    }

    @ApiModelProperty(required=true, value="Plaid's unique identifier for the employer.")
    public String getEmployerId() {
        return this.employerId;
    }

    public void setEmployerId(String employerId) {
        this.employerId = employerId;
    }

    public Employer name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="The name of the employer")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Employer address(AddressDataNullable address) {
        this.address = address;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="")
    public AddressDataNullable getAddress() {
        return this.address;
    }

    public void setAddress(AddressDataNullable address) {
        this.address = address;
    }

    public Employer confidenceScore(Double confidenceScore) {
        this.confidenceScore = confidenceScore;
        return this;
    }

    @ApiModelProperty(required=true, value="A number from 0 to 1 indicating Plaid's level of confidence in the pairing between the employer and the institution (not yet implemented).")
    public Double getConfidenceScore() {
        return this.confidenceScore;
    }

    public void setConfidenceScore(Double confidenceScore) {
        this.confidenceScore = confidenceScore;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Employer employer = (Employer)o;
        return Objects.equals(this.employerId, employer.employerId) && Objects.equals(this.name, employer.name) && Objects.equals(this.address, employer.address) && Objects.equals(this.confidenceScore, employer.confidenceScore);
    }

    public int hashCode() {
        return Objects.hash(this.employerId, this.name, this.address, this.confidenceScore);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Employer {\n");
        sb.append("    employerId: ").append(this.toIndentedString(this.employerId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    confidenceScore: ").append(this.toIndentedString(this.confidenceScore)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

