/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="EmployersSearchRequest defines the request schema for `/employers/search`.")
public class EmployersSearchRequest {
    public static final String SERIALIZED_NAME_CLIENT_ID = "client_id";
    @SerializedName(value="client_id")
    private String clientId;
    public static final String SERIALIZED_NAME_SECRET = "secret";
    @SerializedName(value="secret")
    private String secret;
    public static final String SERIALIZED_NAME_QUERY = "query";
    @SerializedName(value="query")
    private String query;
    public static final String SERIALIZED_NAME_PRODUCTS = "products";
    @SerializedName(value="products")
    private List<String> products = new ArrayList<String>();

    public EmployersSearchRequest clientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `client_id`. The `client_id` is required and may be provided either in the `PLAID-CLIENT-ID` header or as part of a request body.")
    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public EmployersSearchRequest secret(String secret) {
        this.secret = secret;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Your Plaid API `secret`. The `secret` is required and may be provided either in the `PLAID-SECRET` header or as part of a request body.")
    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public EmployersSearchRequest query(String query) {
        this.query = query;
        return this;
    }

    @ApiModelProperty(required=true, value="The employer name to be searched for.")
    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public EmployersSearchRequest products(List<String> products) {
        this.products = products;
        return this;
    }

    public EmployersSearchRequest addProductsItem(String productsItem) {
        this.products.add(productsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="The Plaid products the returned employers should support. Currently, this field must be set to `\"deposit_switch\"`.")
    public List<String> getProducts() {
        return this.products;
    }

    public void setProducts(List<String> products) {
        this.products = products;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EmployersSearchRequest employersSearchRequest = (EmployersSearchRequest)o;
        return Objects.equals(this.clientId, employersSearchRequest.clientId) && Objects.equals(this.secret, employersSearchRequest.secret) && Objects.equals(this.query, employersSearchRequest.query) && Objects.equals(this.products, employersSearchRequest.products);
    }

    public int hashCode() {
        return Objects.hash(this.clientId, this.secret, this.query, this.products);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EmployersSearchRequest {\n");
        sb.append("    clientId: ").append(this.toIndentedString(this.clientId)).append("\n");
        sb.append("    secret: ").append(this.toIndentedString(this.secret)).append("\n");
        sb.append("    query: ").append(this.toIndentedString(this.query)).append("\n");
        sb.append("    products: ").append(this.toIndentedString(this.products)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

