/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.Employer;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="EmployersSearchResponse defines the response schema for `/employers/search`.")
public class EmployersSearchResponse {
    public static final String SERIALIZED_NAME_EMPLOYERS = "employers";
    @SerializedName(value="employers")
    private List<Employer> employers = new ArrayList<Employer>();
    public static final String SERIALIZED_NAME_REQUEST_ID = "request_id";
    @SerializedName(value="request_id")
    private String requestId;

    public EmployersSearchResponse employers(List<Employer> employers) {
        this.employers = employers;
        return this;
    }

    public EmployersSearchResponse addEmployersItem(Employer employersItem) {
        this.employers.add(employersItem);
        return this;
    }

    @ApiModelProperty(required=true, value="A list of employers matching the search criteria.")
    public List<Employer> getEmployers() {
        return this.employers;
    }

    public void setEmployers(List<Employer> employers) {
        this.employers = employers;
    }

    public EmployersSearchResponse requestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    @ApiModelProperty(required=true, value="A unique identifier for the request, which can be used for troubleshooting. This identifier, like all Plaid identifiers, is case sensitive.")
    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EmployersSearchResponse employersSearchResponse = (EmployersSearchResponse)o;
        return Objects.equals(this.employers, employersSearchResponse.employers) && Objects.equals(this.requestId, employersSearchResponse.requestId);
    }

    public int hashCode() {
        return Objects.hash(this.employers, this.requestId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EmployersSearchResponse {\n");
        sb.append("    employers: ").append(this.toIndentedString(this.employers)).append("\n");
        sb.append("    requestId: ").append(this.toIndentedString(this.requestId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

