/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.Pay;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="An object representing employment details found on a paystub.")
public class EmploymentDetails {
    public static final String SERIALIZED_NAME_ANNUAL_SALARY = "annual_salary";
    @SerializedName(value="annual_salary")
    private Pay annualSalary;
    public static final String SERIALIZED_NAME_HIRE_DATE = "hire_date";
    @SerializedName(value="hire_date")
    private LocalDate hireDate;

    public EmploymentDetails annualSalary(Pay annualSalary) {
        this.annualSalary = annualSalary;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Pay getAnnualSalary() {
        return this.annualSalary;
    }

    public void setAnnualSalary(Pay annualSalary) {
        this.annualSalary = annualSalary;
    }

    public EmploymentDetails hireDate(LocalDate hireDate) {
        this.hireDate = hireDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Date on which the employee was hired, in the YYYY-MM-DD format.")
    public LocalDate getHireDate() {
        return this.hireDate;
    }

    public void setHireDate(LocalDate hireDate) {
        this.hireDate = hireDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EmploymentDetails employmentDetails = (EmploymentDetails)o;
        return Objects.equals(this.annualSalary, employmentDetails.annualSalary) && Objects.equals(this.hireDate, employmentDetails.hireDate);
    }

    public int hashCode() {
        return Objects.hash(this.annualSalary, this.hireDate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EmploymentDetails {\n");
        sb.append("    annualSalary: ").append(this.toIndentedString(this.annualSalary)).append("\n");
        sb.append("    hireDate: ").append(this.toIndentedString(this.hireDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

