/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.EmployerVerification;
import com.plaid.client.model.EmploymentVerificationStatus;
import com.plaid.client.model.PlatformIds;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="An object containing proof of employment data for an individual")
public class EmploymentVerification {
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private EmploymentVerificationStatus status;
    public static final String SERIALIZED_NAME_START_DATE = "start_date";
    @SerializedName(value="start_date")
    private LocalDate startDate;
    public static final String SERIALIZED_NAME_END_DATE = "end_date";
    @SerializedName(value="end_date")
    private LocalDate endDate;
    public static final String SERIALIZED_NAME_EMPLOYER = "employer";
    @SerializedName(value="employer")
    private EmployerVerification employer;
    public static final String SERIALIZED_NAME_TITLE = "title";
    @SerializedName(value="title")
    private String title;
    public static final String SERIALIZED_NAME_PLATFORM_IDS = "platform_ids";
    @SerializedName(value="platform_ids")
    private PlatformIds platformIds;

    public EmploymentVerification status(EmploymentVerificationStatus status) {
        this.status = status;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public EmploymentVerificationStatus getStatus() {
        return this.status;
    }

    public void setStatus(EmploymentVerificationStatus status) {
        this.status = status;
    }

    public EmploymentVerification startDate(LocalDate startDate) {
        this.startDate = startDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Start of employment in ISO 8601 format (YYYY-MM-DD).")
    public LocalDate getStartDate() {
        return this.startDate;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public EmploymentVerification endDate(LocalDate endDate) {
        this.endDate = endDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="End of employment, if applicable. Provided in ISO 8601 format (YYY-MM-DD).")
    public LocalDate getEndDate() {
        return this.endDate;
    }

    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public EmploymentVerification employer(EmployerVerification employer) {
        this.employer = employer;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public EmployerVerification getEmployer() {
        return this.employer;
    }

    public void setEmployer(EmployerVerification employer) {
        this.employer = employer;
    }

    public EmploymentVerification title(String title) {
        this.title = title;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Current title of employee.")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public EmploymentVerification platformIds(PlatformIds platformIds) {
        this.platformIds = platformIds;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public PlatformIds getPlatformIds() {
        return this.platformIds;
    }

    public void setPlatformIds(PlatformIds platformIds) {
        this.platformIds = platformIds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EmploymentVerification employmentVerification = (EmploymentVerification)o;
        return Objects.equals((Object)this.status, (Object)employmentVerification.status) && Objects.equals(this.startDate, employmentVerification.startDate) && Objects.equals(this.endDate, employmentVerification.endDate) && Objects.equals(this.employer, employmentVerification.employer) && Objects.equals(this.title, employmentVerification.title) && Objects.equals(this.platformIds, employmentVerification.platformIds);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.status, this.startDate, this.endDate, this.employer, this.title, this.platformIds});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EmploymentVerification {\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    employer: ").append(this.toIndentedString(this.employer)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    platformIds: ").append(this.toIndentedString(this.platformIds)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

