/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.Counterparty;
import com.plaid.client.model.Location;
import com.plaid.client.model.PaymentChannel;
import com.plaid.client.model.PersonalFinanceCategory;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="A grouping of the Plaid produced transaction enhancement fields.")
public class Enhancements {
    public static final String SERIALIZED_NAME_MERCHANT_NAME = "merchant_name";
    @SerializedName(value="merchant_name")
    private String merchantName;
    public static final String SERIALIZED_NAME_WEBSITE = "website";
    @SerializedName(value="website")
    private String website;
    public static final String SERIALIZED_NAME_LOGO_URL = "logo_url";
    @SerializedName(value="logo_url")
    private String logoUrl;
    public static final String SERIALIZED_NAME_CHECK_NUMBER = "check_number";
    @SerializedName(value="check_number")
    private String checkNumber;
    public static final String SERIALIZED_NAME_PAYMENT_CHANNEL = "payment_channel";
    @SerializedName(value="payment_channel")
    private PaymentChannel paymentChannel;
    public static final String SERIALIZED_NAME_CATEGORY_ID = "category_id";
    @SerializedName(value="category_id")
    private String categoryId;
    public static final String SERIALIZED_NAME_CATEGORY = "category";
    @SerializedName(value="category")
    private List<String> category = new ArrayList<String>();
    public static final String SERIALIZED_NAME_LOCATION = "location";
    @SerializedName(value="location")
    private Location location;
    public static final String SERIALIZED_NAME_PERSONAL_FINANCE_CATEGORY = "personal_finance_category";
    @SerializedName(value="personal_finance_category")
    private PersonalFinanceCategory personalFinanceCategory;
    public static final String SERIALIZED_NAME_PERSONAL_FINANCE_CATEGORY_ICON_URL = "personal_finance_category_icon_url";
    @SerializedName(value="personal_finance_category_icon_url")
    private String personalFinanceCategoryIconUrl;
    public static final String SERIALIZED_NAME_COUNTERPARTIES = "counterparties";
    @SerializedName(value="counterparties")
    private List<Counterparty> counterparties = null;

    public Enhancements merchantName(String merchantName) {
        this.merchantName = merchantName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The name of the primary counterparty, such as the merchant or the financial institution, as extracted by Plaid from the raw description.")
    public String getMerchantName() {
        return this.merchantName;
    }

    public void setMerchantName(String merchantName) {
        this.merchantName = merchantName;
    }

    public Enhancements website(String website) {
        this.website = website;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The website associated with this transaction, if available.")
    public String getWebsite() {
        return this.website;
    }

    public void setWebsite(String website) {
        this.website = website;
    }

    public Enhancements logoUrl(String logoUrl) {
        this.logoUrl = logoUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The URL of a logo associated with this transaction, if available. The logo will always be 100\u00d7100 pixel PNG file.")
    public String getLogoUrl() {
        return this.logoUrl;
    }

    public void setLogoUrl(String logoUrl) {
        this.logoUrl = logoUrl;
    }

    public Enhancements checkNumber(String checkNumber) {
        this.checkNumber = checkNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The check number of the transaction. This field is only populated for check transactions.")
    public String getCheckNumber() {
        return this.checkNumber;
    }

    public void setCheckNumber(String checkNumber) {
        this.checkNumber = checkNumber;
    }

    public Enhancements paymentChannel(PaymentChannel paymentChannel) {
        this.paymentChannel = paymentChannel;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public PaymentChannel getPaymentChannel() {
        return this.paymentChannel;
    }

    public void setPaymentChannel(PaymentChannel paymentChannel) {
        this.paymentChannel = paymentChannel;
    }

    public Enhancements categoryId(String categoryId) {
        this.categoryId = categoryId;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The ID of the category to which this transaction belongs. For a full list of categories, see [`/categories/get`](https://plaid.com/docs/api/products/transactions/#categoriesget).")
    public String getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(String categoryId) {
        this.categoryId = categoryId;
    }

    public Enhancements category(List<String> category) {
        this.category = category;
        return this;
    }

    public Enhancements addCategoryItem(String categoryItem) {
        this.category.add(categoryItem);
        return this;
    }

    @ApiModelProperty(required=true, value="A hierarchical array of the categories to which this transaction belongs. For a full list of categories, see [`/categories/get`](https://plaid.com/docs/api/products/transactions/#categoriesget).")
    public List<String> getCategory() {
        return this.category;
    }

    public void setCategory(List<String> category) {
        this.category = category;
    }

    public Enhancements location(Location location) {
        this.location = location;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public Enhancements personalFinanceCategory(PersonalFinanceCategory personalFinanceCategory) {
        this.personalFinanceCategory = personalFinanceCategory;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public PersonalFinanceCategory getPersonalFinanceCategory() {
        return this.personalFinanceCategory;
    }

    public void setPersonalFinanceCategory(PersonalFinanceCategory personalFinanceCategory) {
        this.personalFinanceCategory = personalFinanceCategory;
    }

    public Enhancements personalFinanceCategoryIconUrl(String personalFinanceCategoryIconUrl) {
        this.personalFinanceCategoryIconUrl = personalFinanceCategoryIconUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The URL of an icon associated with the primary personal finance category. The icon will always be 100\u00d7100 pixel PNG file.")
    public String getPersonalFinanceCategoryIconUrl() {
        return this.personalFinanceCategoryIconUrl;
    }

    public void setPersonalFinanceCategoryIconUrl(String personalFinanceCategoryIconUrl) {
        this.personalFinanceCategoryIconUrl = personalFinanceCategoryIconUrl;
    }

    public Enhancements counterparties(List<Counterparty> counterparties) {
        this.counterparties = counterparties;
        return this;
    }

    public Enhancements addCounterpartiesItem(Counterparty counterpartiesItem) {
        if (this.counterparties == null) {
            this.counterparties = new ArrayList<Counterparty>();
        }
        this.counterparties.add(counterpartiesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The counterparties present in the transaction. Counterparties, such as the merchant or the financial institution, are extracted by Plaid from the raw description.")
    public List<Counterparty> getCounterparties() {
        return this.counterparties;
    }

    public void setCounterparties(List<Counterparty> counterparties) {
        this.counterparties = counterparties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Enhancements enhancements = (Enhancements)o;
        return Objects.equals(this.merchantName, enhancements.merchantName) && Objects.equals(this.website, enhancements.website) && Objects.equals(this.logoUrl, enhancements.logoUrl) && Objects.equals(this.checkNumber, enhancements.checkNumber) && Objects.equals((Object)this.paymentChannel, (Object)enhancements.paymentChannel) && Objects.equals(this.categoryId, enhancements.categoryId) && Objects.equals(this.category, enhancements.category) && Objects.equals(this.location, enhancements.location) && Objects.equals(this.personalFinanceCategory, enhancements.personalFinanceCategory) && Objects.equals(this.personalFinanceCategoryIconUrl, enhancements.personalFinanceCategoryIconUrl) && Objects.equals(this.counterparties, enhancements.counterparties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.merchantName, this.website, this.logoUrl, this.checkNumber, this.paymentChannel, this.categoryId, this.category, this.location, this.personalFinanceCategory, this.personalFinanceCategoryIconUrl, this.counterparties});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Enhancements {\n");
        sb.append("    merchantName: ").append(this.toIndentedString(this.merchantName)).append("\n");
        sb.append("    website: ").append(this.toIndentedString(this.website)).append("\n");
        sb.append("    logoUrl: ").append(this.toIndentedString(this.logoUrl)).append("\n");
        sb.append("    checkNumber: ").append(this.toIndentedString(this.checkNumber)).append("\n");
        sb.append("    paymentChannel: ").append(this.toIndentedString((Object)this.paymentChannel)).append("\n");
        sb.append("    categoryId: ").append(this.toIndentedString(this.categoryId)).append("\n");
        sb.append("    category: ").append(this.toIndentedString(this.category)).append("\n");
        sb.append("    location: ").append(this.toIndentedString(this.location)).append("\n");
        sb.append("    personalFinanceCategory: ").append(this.toIndentedString(this.personalFinanceCategory)).append("\n");
        sb.append("    personalFinanceCategoryIconUrl: ").append(this.toIndentedString(this.personalFinanceCategoryIconUrl)).append("\n");
        sb.append("    counterparties: ").append(this.toIndentedString(this.counterparties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

