/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.Counterparty;
import com.plaid.client.model.Location;
import com.plaid.client.model.PaymentChannel;
import com.plaid.client.model.PersonalFinanceCategory;
import com.plaid.client.model.Recurrence;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="A grouping of the Plaid produced transaction enrichment fields.")
public class Enrichments {
    public static final String SERIALIZED_NAME_CHECK_NUMBER = "check_number";
    @SerializedName(value="check_number")
    private String checkNumber;
    public static final String SERIALIZED_NAME_COUNTERPARTIES = "counterparties";
    @SerializedName(value="counterparties")
    private List<Counterparty> counterparties = new ArrayList<Counterparty>();
    public static final String SERIALIZED_NAME_ENTITY_ID = "entity_id";
    @SerializedName(value="entity_id")
    private String entityId;
    public static final String SERIALIZED_NAME_LEGACY_CATEGORY_ID = "legacy_category_id";
    @SerializedName(value="legacy_category_id")
    private String legacyCategoryId;
    public static final String SERIALIZED_NAME_LEGACY_CATEGORY = "legacy_category";
    @SerializedName(value="legacy_category")
    private List<String> legacyCategory = null;
    public static final String SERIALIZED_NAME_LOCATION = "location";
    @SerializedName(value="location")
    private Location location;
    public static final String SERIALIZED_NAME_LOGO_URL = "logo_url";
    @SerializedName(value="logo_url")
    private String logoUrl;
    public static final String SERIALIZED_NAME_MERCHANT_NAME = "merchant_name";
    @SerializedName(value="merchant_name")
    private String merchantName;
    public static final String SERIALIZED_NAME_PAYMENT_CHANNEL = "payment_channel";
    @SerializedName(value="payment_channel")
    private PaymentChannel paymentChannel;
    public static final String SERIALIZED_NAME_PHONE_NUMBER = "phone_number";
    @SerializedName(value="phone_number")
    private String phoneNumber;
    public static final String SERIALIZED_NAME_PERSONAL_FINANCE_CATEGORY = "personal_finance_category";
    @SerializedName(value="personal_finance_category")
    private PersonalFinanceCategory personalFinanceCategory;
    public static final String SERIALIZED_NAME_PERSONAL_FINANCE_CATEGORY_ICON_URL = "personal_finance_category_icon_url";
    @SerializedName(value="personal_finance_category_icon_url")
    private String personalFinanceCategoryIconUrl;
    public static final String SERIALIZED_NAME_RECURRENCE = "recurrence";
    @SerializedName(value="recurrence")
    private Recurrence recurrence;
    public static final String SERIALIZED_NAME_WEBSITE = "website";
    @SerializedName(value="website")
    private String website;

    public Enrichments checkNumber(String checkNumber) {
        this.checkNumber = checkNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The check number of the transaction. This field is only populated for check transactions.")
    public String getCheckNumber() {
        return this.checkNumber;
    }

    public void setCheckNumber(String checkNumber) {
        this.checkNumber = checkNumber;
    }

    public Enrichments counterparties(List<Counterparty> counterparties) {
        this.counterparties = counterparties;
        return this;
    }

    public Enrichments addCounterpartiesItem(Counterparty counterpartiesItem) {
        this.counterparties.add(counterpartiesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="The counterparties present in the transaction. Counterparties, such as the merchant or the financial institution, are extracted by Plaid from the raw description.")
    public List<Counterparty> getCounterparties() {
        return this.counterparties;
    }

    public void setCounterparties(List<Counterparty> counterparties) {
        this.counterparties = counterparties;
    }

    public Enrichments entityId(String entityId) {
        this.entityId = entityId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A unique, stable, Plaid-generated ID that maps to the primary counterparty.")
    public String getEntityId() {
        return this.entityId;
    }

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public Enrichments legacyCategoryId(String legacyCategoryId) {
        this.legacyCategoryId = legacyCategoryId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The ID of the legacy category to which this transaction belongs. For a full list of legacy categories, see [`/categories/get`](https://plaid.com/docs/api/products/transactions/#categoriesget).  We recommend using the `personal_finance_category` for transaction categorization to obtain the best results.")
    public String getLegacyCategoryId() {
        return this.legacyCategoryId;
    }

    public void setLegacyCategoryId(String legacyCategoryId) {
        this.legacyCategoryId = legacyCategoryId;
    }

    public Enrichments legacyCategory(List<String> legacyCategory) {
        this.legacyCategory = legacyCategory;
        return this;
    }

    public Enrichments addLegacyCategoryItem(String legacyCategoryItem) {
        if (this.legacyCategory == null) {
            this.legacyCategory = new ArrayList<String>();
        }
        this.legacyCategory.add(legacyCategoryItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A hierarchical array of the legacy categories to which this transaction belongs. For a full list of legacy categories, see [`/categories/get`](https://plaid.com/docs/api/products/transactions/#categoriesget).  We recommend using the `personal_finance_category` for transaction categorization to obtain the best results.")
    public List<String> getLegacyCategory() {
        return this.legacyCategory;
    }

    public void setLegacyCategory(List<String> legacyCategory) {
        this.legacyCategory = legacyCategory;
    }

    public Enrichments location(Location location) {
        this.location = location;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public Enrichments logoUrl(String logoUrl) {
        this.logoUrl = logoUrl;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The URL of a logo associated with this transaction, if available. The logo will always be 100\u00d7100 pixel PNG file.")
    public String getLogoUrl() {
        return this.logoUrl;
    }

    public void setLogoUrl(String logoUrl) {
        this.logoUrl = logoUrl;
    }

    public Enrichments merchantName(String merchantName) {
        this.merchantName = merchantName;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The name of the primary counterparty, such as the merchant or the financial institution, as extracted by Plaid from the raw description.")
    public String getMerchantName() {
        return this.merchantName;
    }

    public void setMerchantName(String merchantName) {
        this.merchantName = merchantName;
    }

    public Enrichments paymentChannel(PaymentChannel paymentChannel) {
        this.paymentChannel = paymentChannel;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public PaymentChannel getPaymentChannel() {
        return this.paymentChannel;
    }

    public void setPaymentChannel(PaymentChannel paymentChannel) {
        this.paymentChannel = paymentChannel;
    }

    public Enrichments phoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The phone number associated with the counterparty in E. 164 format. If there is a location match (i.e. a street address is returned in the location object), the phone number will be location specific.")
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public Enrichments personalFinanceCategory(PersonalFinanceCategory personalFinanceCategory) {
        this.personalFinanceCategory = personalFinanceCategory;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="")
    public PersonalFinanceCategory getPersonalFinanceCategory() {
        return this.personalFinanceCategory;
    }

    public void setPersonalFinanceCategory(PersonalFinanceCategory personalFinanceCategory) {
        this.personalFinanceCategory = personalFinanceCategory;
    }

    public Enrichments personalFinanceCategoryIconUrl(String personalFinanceCategoryIconUrl) {
        this.personalFinanceCategoryIconUrl = personalFinanceCategoryIconUrl;
        return this;
    }

    @ApiModelProperty(required=true, value="The URL of an icon associated with the primary personal finance category. The icon will always be 100\u00d7100 pixel PNG file.")
    public String getPersonalFinanceCategoryIconUrl() {
        return this.personalFinanceCategoryIconUrl;
    }

    public void setPersonalFinanceCategoryIconUrl(String personalFinanceCategoryIconUrl) {
        this.personalFinanceCategoryIconUrl = personalFinanceCategoryIconUrl;
    }

    public Enrichments recurrence(Recurrence recurrence) {
        this.recurrence = recurrence;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Recurrence getRecurrence() {
        return this.recurrence;
    }

    public void setRecurrence(Recurrence recurrence) {
        this.recurrence = recurrence;
    }

    public Enrichments website(String website) {
        this.website = website;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The website associated with this transaction.")
    public String getWebsite() {
        return this.website;
    }

    public void setWebsite(String website) {
        this.website = website;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Enrichments enrichments = (Enrichments)o;
        return Objects.equals(this.checkNumber, enrichments.checkNumber) && Objects.equals(this.counterparties, enrichments.counterparties) && Objects.equals(this.entityId, enrichments.entityId) && Objects.equals(this.legacyCategoryId, enrichments.legacyCategoryId) && Objects.equals(this.legacyCategory, enrichments.legacyCategory) && Objects.equals(this.location, enrichments.location) && Objects.equals(this.logoUrl, enrichments.logoUrl) && Objects.equals(this.merchantName, enrichments.merchantName) && Objects.equals((Object)this.paymentChannel, (Object)enrichments.paymentChannel) && Objects.equals(this.phoneNumber, enrichments.phoneNumber) && Objects.equals(this.personalFinanceCategory, enrichments.personalFinanceCategory) && Objects.equals(this.personalFinanceCategoryIconUrl, enrichments.personalFinanceCategoryIconUrl) && Objects.equals(this.recurrence, enrichments.recurrence) && Objects.equals(this.website, enrichments.website);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.checkNumber, this.counterparties, this.entityId, this.legacyCategoryId, this.legacyCategory, this.location, this.logoUrl, this.merchantName, this.paymentChannel, this.phoneNumber, this.personalFinanceCategory, this.personalFinanceCategoryIconUrl, this.recurrence, this.website});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Enrichments {\n");
        sb.append("    checkNumber: ").append(this.toIndentedString(this.checkNumber)).append("\n");
        sb.append("    counterparties: ").append(this.toIndentedString(this.counterparties)).append("\n");
        sb.append("    entityId: ").append(this.toIndentedString(this.entityId)).append("\n");
        sb.append("    legacyCategoryId: ").append(this.toIndentedString(this.legacyCategoryId)).append("\n");
        sb.append("    legacyCategory: ").append(this.toIndentedString(this.legacyCategory)).append("\n");
        sb.append("    location: ").append(this.toIndentedString(this.location)).append("\n");
        sb.append("    logoUrl: ").append(this.toIndentedString(this.logoUrl)).append("\n");
        sb.append("    merchantName: ").append(this.toIndentedString(this.merchantName)).append("\n");
        sb.append("    paymentChannel: ").append(this.toIndentedString((Object)this.paymentChannel)).append("\n");
        sb.append("    phoneNumber: ").append(this.toIndentedString(this.phoneNumber)).append("\n");
        sb.append("    personalFinanceCategory: ").append(this.toIndentedString(this.personalFinanceCategory)).append("\n");
        sb.append("    personalFinanceCategoryIconUrl: ").append(this.toIndentedString(this.personalFinanceCategoryIconUrl)).append("\n");
        sb.append("    recurrence: ").append(this.toIndentedString(this.recurrence)).append("\n");
        sb.append("    website: ").append(this.toIndentedString(this.website)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

