/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.MatchSummaryCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Analysis information describing why a screening hit matched the provided entity information")
public class EntityScreeningHitAnalysis {
    public static final String SERIALIZED_NAME_DOCUMENTS = "documents";
    @SerializedName(value="documents")
    private MatchSummaryCode documents;
    public static final String SERIALIZED_NAME_EMAIL_ADDRESSES = "email_addresses";
    @SerializedName(value="email_addresses")
    private MatchSummaryCode emailAddresses;
    public static final String SERIALIZED_NAME_LOCATIONS = "locations";
    @SerializedName(value="locations")
    private MatchSummaryCode locations;
    public static final String SERIALIZED_NAME_NAMES = "names";
    @SerializedName(value="names")
    private MatchSummaryCode names;
    public static final String SERIALIZED_NAME_PHONE_NUMBERS = "phone_numbers";
    @SerializedName(value="phone_numbers")
    private MatchSummaryCode phoneNumbers;
    public static final String SERIALIZED_NAME_URLS = "urls";
    @SerializedName(value="urls")
    private MatchSummaryCode urls;
    public static final String SERIALIZED_NAME_SEARCH_TERMS_VERSION = "search_terms_version";
    @SerializedName(value="search_terms_version")
    private Integer searchTermsVersion;

    public EntityScreeningHitAnalysis documents(MatchSummaryCode documents) {
        this.documents = documents;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public MatchSummaryCode getDocuments() {
        return this.documents;
    }

    public void setDocuments(MatchSummaryCode documents) {
        this.documents = documents;
    }

    public EntityScreeningHitAnalysis emailAddresses(MatchSummaryCode emailAddresses) {
        this.emailAddresses = emailAddresses;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public MatchSummaryCode getEmailAddresses() {
        return this.emailAddresses;
    }

    public void setEmailAddresses(MatchSummaryCode emailAddresses) {
        this.emailAddresses = emailAddresses;
    }

    public EntityScreeningHitAnalysis locations(MatchSummaryCode locations) {
        this.locations = locations;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public MatchSummaryCode getLocations() {
        return this.locations;
    }

    public void setLocations(MatchSummaryCode locations) {
        this.locations = locations;
    }

    public EntityScreeningHitAnalysis names(MatchSummaryCode names) {
        this.names = names;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public MatchSummaryCode getNames() {
        return this.names;
    }

    public void setNames(MatchSummaryCode names) {
        this.names = names;
    }

    public EntityScreeningHitAnalysis phoneNumbers(MatchSummaryCode phoneNumbers) {
        this.phoneNumbers = phoneNumbers;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public MatchSummaryCode getPhoneNumbers() {
        return this.phoneNumbers;
    }

    public void setPhoneNumbers(MatchSummaryCode phoneNumbers) {
        this.phoneNumbers = phoneNumbers;
    }

    public EntityScreeningHitAnalysis urls(MatchSummaryCode urls) {
        this.urls = urls;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public MatchSummaryCode getUrls() {
        return this.urls;
    }

    public void setUrls(MatchSummaryCode urls) {
        this.urls = urls;
    }

    public EntityScreeningHitAnalysis searchTermsVersion(Integer searchTermsVersion) {
        this.searchTermsVersion = searchTermsVersion;
        return this;
    }

    @ApiModelProperty(example="1", required=true, value="The version of the entity screening's `search_terms` that were compared when the entity screening hit was added. entity screening hits are immutable once they have been reviewed. If changes are detected due to updates to the entity screening's `search_terms`, the associated entity program, or the list's source data prior to review, the entity screening hit will be updated to reflect those changes.")
    public Integer getSearchTermsVersion() {
        return this.searchTermsVersion;
    }

    public void setSearchTermsVersion(Integer searchTermsVersion) {
        this.searchTermsVersion = searchTermsVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntityScreeningHitAnalysis entityScreeningHitAnalysis = (EntityScreeningHitAnalysis)o;
        return Objects.equals((Object)this.documents, (Object)entityScreeningHitAnalysis.documents) && Objects.equals((Object)this.emailAddresses, (Object)entityScreeningHitAnalysis.emailAddresses) && Objects.equals((Object)this.locations, (Object)entityScreeningHitAnalysis.locations) && Objects.equals((Object)this.names, (Object)entityScreeningHitAnalysis.names) && Objects.equals((Object)this.phoneNumbers, (Object)entityScreeningHitAnalysis.phoneNumbers) && Objects.equals((Object)this.urls, (Object)entityScreeningHitAnalysis.urls) && Objects.equals(this.searchTermsVersion, entityScreeningHitAnalysis.searchTermsVersion);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.documents, this.emailAddresses, this.locations, this.names, this.phoneNumbers, this.urls, this.searchTermsVersion});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EntityScreeningHitAnalysis {\n");
        sb.append("    documents: ").append(this.toIndentedString((Object)this.documents)).append("\n");
        sb.append("    emailAddresses: ").append(this.toIndentedString((Object)this.emailAddresses)).append("\n");
        sb.append("    locations: ").append(this.toIndentedString((Object)this.locations)).append("\n");
        sb.append("    names: ").append(this.toIndentedString((Object)this.names)).append("\n");
        sb.append("    phoneNumbers: ").append(this.toIndentedString((Object)this.phoneNumbers)).append("\n");
        sb.append("    urls: ").append(this.toIndentedString((Object)this.urls)).append("\n");
        sb.append("    searchTermsVersion: ").append(this.toIndentedString(this.searchTermsVersion)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

