/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.WebhookEnvironmentValues;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Fired when an entity screening status has changed, which can occur manually via the dashboard or during ongoing monitoring.")
public class EntityScreeningStatusUpdatedWebhook {
    public static final String SERIALIZED_NAME_WEBHOOK_TYPE = "webhook_type";
    @SerializedName(value="webhook_type")
    private String webhookType;
    public static final String SERIALIZED_NAME_WEBHOOK_CODE = "webhook_code";
    @SerializedName(value="webhook_code")
    private String webhookCode;
    public static final String SERIALIZED_NAME_ENTITY_SCREENING_ID = "entity_screening_id";
    @SerializedName(value="entity_screening_id")
    private String entityScreeningId;
    public static final String SERIALIZED_NAME_ENVIRONMENT = "environment";
    @SerializedName(value="environment")
    private WebhookEnvironmentValues environment;

    public EntityScreeningStatusUpdatedWebhook webhookType(String webhookType) {
        this.webhookType = webhookType;
        return this;
    }

    @ApiModelProperty(required=true, value="`ENTITY_SCREENING`")
    public String getWebhookType() {
        return this.webhookType;
    }

    public void setWebhookType(String webhookType) {
        this.webhookType = webhookType;
    }

    public EntityScreeningStatusUpdatedWebhook webhookCode(String webhookCode) {
        this.webhookCode = webhookCode;
        return this;
    }

    @ApiModelProperty(required=true, value="`STATUS_UPDATED`")
    public String getWebhookCode() {
        return this.webhookCode;
    }

    public void setWebhookCode(String webhookCode) {
        this.webhookCode = webhookCode;
    }

    public EntityScreeningStatusUpdatedWebhook entityScreeningId(String entityScreeningId) {
        this.entityScreeningId = entityScreeningId;
        return this;
    }

    @ApiModelProperty(required=true, value="The ID of the associated entity screening.")
    public String getEntityScreeningId() {
        return this.entityScreeningId;
    }

    public void setEntityScreeningId(String entityScreeningId) {
        this.entityScreeningId = entityScreeningId;
    }

    public EntityScreeningStatusUpdatedWebhook environment(WebhookEnvironmentValues environment) {
        this.environment = environment;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public WebhookEnvironmentValues getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(WebhookEnvironmentValues environment) {
        this.environment = environment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntityScreeningStatusUpdatedWebhook entityScreeningStatusUpdatedWebhook = (EntityScreeningStatusUpdatedWebhook)o;
        return Objects.equals(this.webhookType, entityScreeningStatusUpdatedWebhook.webhookType) && Objects.equals(this.webhookCode, entityScreeningStatusUpdatedWebhook.webhookCode) && Objects.equals(this.entityScreeningId, entityScreeningStatusUpdatedWebhook.entityScreeningId) && Objects.equals((Object)this.environment, (Object)entityScreeningStatusUpdatedWebhook.environment);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.webhookType, this.webhookCode, this.entityScreeningId, this.environment});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EntityScreeningStatusUpdatedWebhook {\n");
        sb.append("    webhookType: ").append(this.toIndentedString(this.webhookType)).append("\n");
        sb.append("    webhookCode: ").append(this.toIndentedString(this.webhookCode)).append("\n");
        sb.append("    entityScreeningId: ").append(this.toIndentedString(this.entityScreeningId)).append("\n");
        sb.append("    environment: ").append(this.toIndentedString((Object)this.environment)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

