/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.EntityWatchlistCode;
import com.plaid.client.model.ProgramNameSensitivity;
import com.plaid.client.model.WatchlistScreeningAuditTrail;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.sql.Timestamp;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;

@ApiModel(description="A program that configures the active lists, search parameters, and other behavior for initial and ongoing screening of entities.")
public class EntityWatchlistProgram {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_CREATED_AT = "created_at";
    @SerializedName(value="created_at")
    private Timestamp createdAt;
    public static final String SERIALIZED_NAME_IS_RESCANNING_ENABLED = "is_rescanning_enabled";
    @SerializedName(value="is_rescanning_enabled")
    private Boolean isRescanningEnabled;
    public static final String SERIALIZED_NAME_LISTS_ENABLED = "lists_enabled";
    @SerializedName(value="lists_enabled")
    private Set<EntityWatchlistCode> listsEnabled = new LinkedHashSet<EntityWatchlistCode>();
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_NAME_SENSITIVITY = "name_sensitivity";
    @SerializedName(value="name_sensitivity")
    private ProgramNameSensitivity nameSensitivity;
    public static final String SERIALIZED_NAME_AUDIT_TRAIL = "audit_trail";
    @SerializedName(value="audit_trail")
    private WatchlistScreeningAuditTrail auditTrail;
    public static final String SERIALIZED_NAME_IS_ARCHIVED = "is_archived";
    @SerializedName(value="is_archived")
    private Boolean isArchived;

    public EntityWatchlistProgram id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="entprg_2eRPsDnL66rZ7H", required=true, value="ID of the associated entity program.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public EntityWatchlistProgram createdAt(Timestamp createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Timestamp getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(Timestamp createdAt) {
        this.createdAt = createdAt;
    }

    public EntityWatchlistProgram isRescanningEnabled(Boolean isRescanningEnabled) {
        this.isRescanningEnabled = isRescanningEnabled;
        return this;
    }

    @ApiModelProperty(example="true", required=true, value="Indicator specifying whether the program is enabled and will perform daily rescans.")
    public Boolean getIsRescanningEnabled() {
        return this.isRescanningEnabled;
    }

    public void setIsRescanningEnabled(Boolean isRescanningEnabled) {
        this.isRescanningEnabled = isRescanningEnabled;
    }

    public EntityWatchlistProgram listsEnabled(Set<EntityWatchlistCode> listsEnabled) {
        this.listsEnabled = listsEnabled;
        return this;
    }

    public EntityWatchlistProgram addListsEnabledItem(EntityWatchlistCode listsEnabledItem) {
        this.listsEnabled.add(listsEnabledItem);
        return this;
    }

    @ApiModelProperty(example="[\"EU_CON\"]", required=true, value="Watchlists enabled for the associated program")
    public Set<EntityWatchlistCode> getListsEnabled() {
        return this.listsEnabled;
    }

    public void setListsEnabled(Set<EntityWatchlistCode> listsEnabled) {
        this.listsEnabled = listsEnabled;
    }

    public EntityWatchlistProgram name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(example="Sample Program", required=true, value="A name for the entity program to define its purpose. For example, \"High Risk Organizations\" or \"Applicants\".")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public EntityWatchlistProgram nameSensitivity(ProgramNameSensitivity nameSensitivity) {
        this.nameSensitivity = nameSensitivity;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public ProgramNameSensitivity getNameSensitivity() {
        return this.nameSensitivity;
    }

    public void setNameSensitivity(ProgramNameSensitivity nameSensitivity) {
        this.nameSensitivity = nameSensitivity;
    }

    public EntityWatchlistProgram auditTrail(WatchlistScreeningAuditTrail auditTrail) {
        this.auditTrail = auditTrail;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public WatchlistScreeningAuditTrail getAuditTrail() {
        return this.auditTrail;
    }

    public void setAuditTrail(WatchlistScreeningAuditTrail auditTrail) {
        this.auditTrail = auditTrail;
    }

    public EntityWatchlistProgram isArchived(Boolean isArchived) {
        this.isArchived = isArchived;
        return this;
    }

    @ApiModelProperty(example="false", required=true, value="Archived programs are read-only and cannot screen new customers nor participate in ongoing monitoring.")
    public Boolean getIsArchived() {
        return this.isArchived;
    }

    public void setIsArchived(Boolean isArchived) {
        this.isArchived = isArchived;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntityWatchlistProgram entityWatchlistProgram = (EntityWatchlistProgram)o;
        return Objects.equals(this.id, entityWatchlistProgram.id) && Objects.equals(this.createdAt, entityWatchlistProgram.createdAt) && Objects.equals(this.isRescanningEnabled, entityWatchlistProgram.isRescanningEnabled) && Objects.equals(this.listsEnabled, entityWatchlistProgram.listsEnabled) && Objects.equals(this.name, entityWatchlistProgram.name) && Objects.equals((Object)this.nameSensitivity, (Object)entityWatchlistProgram.nameSensitivity) && Objects.equals(this.auditTrail, entityWatchlistProgram.auditTrail) && Objects.equals(this.isArchived, entityWatchlistProgram.isArchived);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.createdAt, this.isRescanningEnabled, this.listsEnabled, this.name, this.nameSensitivity, this.auditTrail, this.isArchived});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EntityWatchlistProgram {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    isRescanningEnabled: ").append(this.toIndentedString(this.isRescanningEnabled)).append("\n");
        sb.append("    listsEnabled: ").append(this.toIndentedString(this.listsEnabled)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    nameSensitivity: ").append(this.toIndentedString((Object)this.nameSensitivity)).append("\n");
        sb.append("    auditTrail: ").append(this.toIndentedString(this.auditTrail)).append("\n");
        sb.append("    isArchived: ").append(this.toIndentedString(this.isArchived)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

