/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.EntityWatchlistScreeningSearchTerms;
import com.plaid.client.model.WatchlistScreeningAuditTrail;
import com.plaid.client.model.WatchlistScreeningStatus;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The entity screening object allows you to represent an entity in your system, update its profile, and search for it on various watchlists. Note: Rejected entity screenings will not receive new hits, regardless of entity program configuration.")
public class EntityWatchlistScreening {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_SEARCH_TERMS = "search_terms";
    @SerializedName(value="search_terms")
    private EntityWatchlistScreeningSearchTerms searchTerms;
    public static final String SERIALIZED_NAME_ASSIGNEE = "assignee";
    @SerializedName(value="assignee")
    private String assignee;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private WatchlistScreeningStatus status;
    public static final String SERIALIZED_NAME_CLIENT_USER_ID = "client_user_id";
    @SerializedName(value="client_user_id")
    private String clientUserId;
    public static final String SERIALIZED_NAME_AUDIT_TRAIL = "audit_trail";
    @SerializedName(value="audit_trail")
    private WatchlistScreeningAuditTrail auditTrail;

    public EntityWatchlistScreening id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="entscr_52xR9LKo77r1Np", required=true, value="ID of the associated entity screening.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public EntityWatchlistScreening searchTerms(EntityWatchlistScreeningSearchTerms searchTerms) {
        this.searchTerms = searchTerms;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public EntityWatchlistScreeningSearchTerms getSearchTerms() {
        return this.searchTerms;
    }

    public void setSearchTerms(EntityWatchlistScreeningSearchTerms searchTerms) {
        this.searchTerms = searchTerms;
    }

    public EntityWatchlistScreening assignee(String assignee) {
        this.assignee = assignee;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="54350110fedcbaf01234ffee", required=true, value="ID of the associated user.")
    public String getAssignee() {
        return this.assignee;
    }

    public void setAssignee(String assignee) {
        this.assignee = assignee;
    }

    public EntityWatchlistScreening status(WatchlistScreeningStatus status) {
        this.status = status;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public WatchlistScreeningStatus getStatus() {
        return this.status;
    }

    public void setStatus(WatchlistScreeningStatus status) {
        this.status = status;
    }

    public EntityWatchlistScreening clientUserId(String clientUserId) {
        this.clientUserId = clientUserId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="your-db-id-3b24110", required=true, value="A unique ID that identifies the end user in your system. This ID can also be used to associate user-specific data from other Plaid products. Financial Account Matching requires this field and the `/link/token/create` `client_user_id` to be consistent. Personally identifiable information, such as an email address or phone number, should not be used in the `client_user_id`.")
    public String getClientUserId() {
        return this.clientUserId;
    }

    public void setClientUserId(String clientUserId) {
        this.clientUserId = clientUserId;
    }

    public EntityWatchlistScreening auditTrail(WatchlistScreeningAuditTrail auditTrail) {
        this.auditTrail = auditTrail;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public WatchlistScreeningAuditTrail getAuditTrail() {
        return this.auditTrail;
    }

    public void setAuditTrail(WatchlistScreeningAuditTrail auditTrail) {
        this.auditTrail = auditTrail;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntityWatchlistScreening entityWatchlistScreening = (EntityWatchlistScreening)o;
        return Objects.equals(this.id, entityWatchlistScreening.id) && Objects.equals(this.searchTerms, entityWatchlistScreening.searchTerms) && Objects.equals(this.assignee, entityWatchlistScreening.assignee) && Objects.equals((Object)this.status, (Object)entityWatchlistScreening.status) && Objects.equals(this.clientUserId, entityWatchlistScreening.clientUserId) && Objects.equals(this.auditTrail, entityWatchlistScreening.auditTrail);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.searchTerms, this.assignee, this.status, this.clientUserId, this.auditTrail});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EntityWatchlistScreening {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    searchTerms: ").append(this.toIndentedString(this.searchTerms)).append("\n");
        sb.append("    assignee: ").append(this.toIndentedString(this.assignee)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    clientUserId: ").append(this.toIndentedString(this.clientUserId)).append("\n");
        sb.append("    auditTrail: ").append(this.toIndentedString(this.auditTrail)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

