/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.EntityScreeningHitAnalysis;
import com.plaid.client.model.EntityScreeningHitData;
import com.plaid.client.model.EntityWatchlistCode;
import com.plaid.client.model.WatchlistScreeningHitStatus;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.sql.Timestamp;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Data from a government watchlist that has been attached to the screening.")
public class EntityWatchlistScreeningHit {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_REVIEW_STATUS = "review_status";
    @SerializedName(value="review_status")
    private WatchlistScreeningHitStatus reviewStatus;
    public static final String SERIALIZED_NAME_FIRST_ACTIVE = "first_active";
    @SerializedName(value="first_active")
    private Timestamp firstActive;
    public static final String SERIALIZED_NAME_INACTIVE_SINCE = "inactive_since";
    @SerializedName(value="inactive_since")
    private OffsetDateTime inactiveSince;
    public static final String SERIALIZED_NAME_HISTORICAL_SINCE = "historical_since";
    @SerializedName(value="historical_since")
    private OffsetDateTime historicalSince;
    public static final String SERIALIZED_NAME_LIST_CODE = "list_code";
    @SerializedName(value="list_code")
    private EntityWatchlistCode listCode;
    public static final String SERIALIZED_NAME_PLAID_UID = "plaid_uid";
    @SerializedName(value="plaid_uid")
    private String plaidUid;
    public static final String SERIALIZED_NAME_SOURCE_UID = "source_uid";
    @SerializedName(value="source_uid")
    private String sourceUid;
    public static final String SERIALIZED_NAME_ANALYSIS = "analysis";
    @SerializedName(value="analysis")
    private EntityScreeningHitAnalysis analysis;
    public static final String SERIALIZED_NAME_DATA = "data";
    @SerializedName(value="data")
    private EntityScreeningHitData data;

    public EntityWatchlistScreeningHit id(String id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(example="enthit_52xR9LKo77r1Np", required=true, value="ID of the associated entity screening hit.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public EntityWatchlistScreeningHit reviewStatus(WatchlistScreeningHitStatus reviewStatus) {
        this.reviewStatus = reviewStatus;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public WatchlistScreeningHitStatus getReviewStatus() {
        return this.reviewStatus;
    }

    public void setReviewStatus(WatchlistScreeningHitStatus reviewStatus) {
        this.reviewStatus = reviewStatus;
    }

    public EntityWatchlistScreeningHit firstActive(Timestamp firstActive) {
        this.firstActive = firstActive;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public Timestamp getFirstActive() {
        return this.firstActive;
    }

    public void setFirstActive(Timestamp firstActive) {
        this.firstActive = firstActive;
    }

    public EntityWatchlistScreeningHit inactiveSince(OffsetDateTime inactiveSince) {
        this.inactiveSince = inactiveSince;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2020-07-24T03:26:02Z", required=true, value="An ISO8601 formatted timestamp.")
    public OffsetDateTime getInactiveSince() {
        return this.inactiveSince;
    }

    public void setInactiveSince(OffsetDateTime inactiveSince) {
        this.inactiveSince = inactiveSince;
    }

    public EntityWatchlistScreeningHit historicalSince(OffsetDateTime historicalSince) {
        this.historicalSince = historicalSince;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2020-07-24T03:26:02Z", required=true, value="An ISO8601 formatted timestamp.")
    public OffsetDateTime getHistoricalSince() {
        return this.historicalSince;
    }

    public void setHistoricalSince(OffsetDateTime historicalSince) {
        this.historicalSince = historicalSince;
    }

    public EntityWatchlistScreeningHit listCode(EntityWatchlistCode listCode) {
        this.listCode = listCode;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public EntityWatchlistCode getListCode() {
        return this.listCode;
    }

    public void setListCode(EntityWatchlistCode listCode) {
        this.listCode = listCode;
    }

    public EntityWatchlistScreeningHit plaidUid(String plaidUid) {
        this.plaidUid = plaidUid;
        return this;
    }

    @ApiModelProperty(example="uid_3NggckTimGSJHS", required=true, value="A universal identifier for a watchlist individual that is stable across searches and updates.")
    public String getPlaidUid() {
        return this.plaidUid;
    }

    public void setPlaidUid(String plaidUid) {
        this.plaidUid = plaidUid;
    }

    public EntityWatchlistScreeningHit sourceUid(String sourceUid) {
        this.sourceUid = sourceUid;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="26192ABC", required=true, value="The identifier provided by the source sanction or watchlist. When one is not provided by the source, this is `null`.")
    public String getSourceUid() {
        return this.sourceUid;
    }

    public void setSourceUid(String sourceUid) {
        this.sourceUid = sourceUid;
    }

    public EntityWatchlistScreeningHit analysis(EntityScreeningHitAnalysis analysis) {
        this.analysis = analysis;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public EntityScreeningHitAnalysis getAnalysis() {
        return this.analysis;
    }

    public void setAnalysis(EntityScreeningHitAnalysis analysis) {
        this.analysis = analysis;
    }

    public EntityWatchlistScreeningHit data(EntityScreeningHitData data) {
        this.data = data;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public EntityScreeningHitData getData() {
        return this.data;
    }

    public void setData(EntityScreeningHitData data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntityWatchlistScreeningHit entityWatchlistScreeningHit = (EntityWatchlistScreeningHit)o;
        return Objects.equals(this.id, entityWatchlistScreeningHit.id) && Objects.equals((Object)this.reviewStatus, (Object)entityWatchlistScreeningHit.reviewStatus) && Objects.equals(this.firstActive, entityWatchlistScreeningHit.firstActive) && Objects.equals(this.inactiveSince, entityWatchlistScreeningHit.inactiveSince) && Objects.equals(this.historicalSince, entityWatchlistScreeningHit.historicalSince) && Objects.equals((Object)this.listCode, (Object)entityWatchlistScreeningHit.listCode) && Objects.equals(this.plaidUid, entityWatchlistScreeningHit.plaidUid) && Objects.equals(this.sourceUid, entityWatchlistScreeningHit.sourceUid) && Objects.equals(this.analysis, entityWatchlistScreeningHit.analysis) && Objects.equals(this.data, entityWatchlistScreeningHit.data);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.reviewStatus, this.firstActive, this.inactiveSince, this.historicalSince, this.listCode, this.plaidUid, this.sourceUid, this.analysis, this.data});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EntityWatchlistScreeningHit {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    reviewStatus: ").append(this.toIndentedString((Object)this.reviewStatus)).append("\n");
        sb.append("    firstActive: ").append(this.toIndentedString(this.firstActive)).append("\n");
        sb.append("    inactiveSince: ").append(this.toIndentedString(this.inactiveSince)).append("\n");
        sb.append("    historicalSince: ").append(this.toIndentedString(this.historicalSince)).append("\n");
        sb.append("    listCode: ").append(this.toIndentedString((Object)this.listCode)).append("\n");
        sb.append("    plaidUid: ").append(this.toIndentedString(this.plaidUid)).append("\n");
        sb.append("    sourceUid: ").append(this.toIndentedString(this.sourceUid)).append("\n");
        sb.append("    analysis: ").append(this.toIndentedString(this.analysis)).append("\n");
        sb.append("    data: ").append(this.toIndentedString(this.data)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

