/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.net.URI;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Search terms associated with an entity used for searching against watchlists")
public class EntityWatchlistScreeningSearchTerms {
    public static final String SERIALIZED_NAME_ENTITY_WATCHLIST_PROGRAM_ID = "entity_watchlist_program_id";
    @SerializedName(value="entity_watchlist_program_id")
    private String entityWatchlistProgramId;
    public static final String SERIALIZED_NAME_LEGAL_NAME = "legal_name";
    @SerializedName(value="legal_name")
    private String legalName;
    public static final String SERIALIZED_NAME_DOCUMENT_NUMBER = "document_number";
    @SerializedName(value="document_number")
    private String documentNumber;
    public static final String SERIALIZED_NAME_EMAIL_ADDRESS = "email_address";
    @SerializedName(value="email_address")
    private String emailAddress;
    public static final String SERIALIZED_NAME_COUNTRY = "country";
    @SerializedName(value="country")
    private String country;
    public static final String SERIALIZED_NAME_PHONE_NUMBER = "phone_number";
    @SerializedName(value="phone_number")
    private String phoneNumber;
    public static final String SERIALIZED_NAME_URL = "url";
    @SerializedName(value="url")
    private URI url;
    public static final String SERIALIZED_NAME_VERSION = "version";
    @SerializedName(value="version")
    private Integer version;

    public EntityWatchlistScreeningSearchTerms entityWatchlistProgramId(String entityWatchlistProgramId) {
        this.entityWatchlistProgramId = entityWatchlistProgramId;
        return this;
    }

    @ApiModelProperty(example="entprg_2eRPsDnL66rZ7H", required=true, value="ID of the associated entity program.")
    public String getEntityWatchlistProgramId() {
        return this.entityWatchlistProgramId;
    }

    public void setEntityWatchlistProgramId(String entityWatchlistProgramId) {
        this.entityWatchlistProgramId = entityWatchlistProgramId;
    }

    public EntityWatchlistScreeningSearchTerms legalName(String legalName) {
        this.legalName = legalName;
        return this;
    }

    @ApiModelProperty(example="Al-Qaida", required=true, value="The name of the organization being screened.")
    public String getLegalName() {
        return this.legalName;
    }

    public void setLegalName(String legalName) {
        this.legalName = legalName;
    }

    public EntityWatchlistScreeningSearchTerms documentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="C31195855", required=true, value="The numeric or alphanumeric identifier associated with this document.")
    public String getDocumentNumber() {
        return this.documentNumber;
    }

    public void setDocumentNumber(String documentNumber) {
        this.documentNumber = documentNumber;
    }

    public EntityWatchlistScreeningSearchTerms emailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="user@example.com", required=true, value="A valid email address.")
    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public EntityWatchlistScreeningSearchTerms country(String country) {
        this.country = country;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="US", required=true, value="Valid, capitalized, two-letter ISO code representing the country of this object. Must be in ISO 3166-1 alpha-2 form.")
    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public EntityWatchlistScreeningSearchTerms phoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="+14025671234", required=true, value="A phone number in E.164 format.")
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    public void setPhoneNumber(String phoneNumber) {
        this.phoneNumber = phoneNumber;
    }

    public EntityWatchlistScreeningSearchTerms url(URI url) {
        this.url = url;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="https://example.com", required=true, value="An 'http' or 'https' URL (must begin with either of those).")
    public URI getUrl() {
        return this.url;
    }

    public void setUrl(URI url) {
        this.url = url;
    }

    public EntityWatchlistScreeningSearchTerms version(Integer version) {
        this.version = version;
        return this;
    }

    @ApiModelProperty(example="1", required=true, value="The current version of the search terms. Starts at `1` and increments with each edit to `search_terms`.")
    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer version) {
        this.version = version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntityWatchlistScreeningSearchTerms entityWatchlistScreeningSearchTerms = (EntityWatchlistScreeningSearchTerms)o;
        return Objects.equals(this.entityWatchlistProgramId, entityWatchlistScreeningSearchTerms.entityWatchlistProgramId) && Objects.equals(this.legalName, entityWatchlistScreeningSearchTerms.legalName) && Objects.equals(this.documentNumber, entityWatchlistScreeningSearchTerms.documentNumber) && Objects.equals(this.emailAddress, entityWatchlistScreeningSearchTerms.emailAddress) && Objects.equals(this.country, entityWatchlistScreeningSearchTerms.country) && Objects.equals(this.phoneNumber, entityWatchlistScreeningSearchTerms.phoneNumber) && Objects.equals(this.url, entityWatchlistScreeningSearchTerms.url) && Objects.equals(this.version, entityWatchlistScreeningSearchTerms.version);
    }

    public int hashCode() {
        return Objects.hash(this.entityWatchlistProgramId, this.legalName, this.documentNumber, this.emailAddress, this.country, this.phoneNumber, this.url, this.version);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EntityWatchlistScreeningSearchTerms {\n");
        sb.append("    entityWatchlistProgramId: ").append(this.toIndentedString(this.entityWatchlistProgramId)).append("\n");
        sb.append("    legalName: ").append(this.toIndentedString(this.legalName)).append("\n");
        sb.append("    documentNumber: ").append(this.toIndentedString(this.documentNumber)).append("\n");
        sb.append("    emailAddress: ").append(this.toIndentedString(this.emailAddress)).append("\n");
        sb.append("    country: ").append(this.toIndentedString(this.country)).append("\n");
        sb.append("    phoneNumber: ").append(this.toIndentedString(this.phoneNumber)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("    version: ").append(this.toIndentedString(this.version)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

