/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.PaymentInitiationOptionalRestrictionBacs;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Additional payment consent options")
public class ExternalPaymentInitiationConsentOptions {
    public static final String SERIALIZED_NAME_REQUEST_REFUND_DETAILS = "request_refund_details";
    @SerializedName(value="request_refund_details")
    private Boolean requestRefundDetails;
    public static final String SERIALIZED_NAME_IBAN = "iban";
    @SerializedName(value="iban")
    private String iban;
    public static final String SERIALIZED_NAME_BACS = "bacs";
    @SerializedName(value="bacs")
    private PaymentInitiationOptionalRestrictionBacs bacs;

    public ExternalPaymentInitiationConsentOptions requestRefundDetails(Boolean requestRefundDetails) {
        this.requestRefundDetails = requestRefundDetails;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="When `true`, Plaid will attempt to request refund details from the payee's financial institution.  Support varies between financial institutions and will not always be available.  If refund details could be retrieved, they will be available in the `/payment_initiation/payment/get` response.")
    public Boolean getRequestRefundDetails() {
        return this.requestRefundDetails;
    }

    public void setRequestRefundDetails(Boolean requestRefundDetails) {
        this.requestRefundDetails = requestRefundDetails;
    }

    public ExternalPaymentInitiationConsentOptions iban(String iban) {
        this.iban = iban;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The International Bank Account Number (IBAN) for the payer's account. Where possible, the end user will be able to set up payment consent using only the specified bank account if provided.")
    public String getIban() {
        return this.iban;
    }

    public void setIban(String iban) {
        this.iban = iban;
    }

    public ExternalPaymentInitiationConsentOptions bacs(PaymentInitiationOptionalRestrictionBacs bacs) {
        this.bacs = bacs;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public PaymentInitiationOptionalRestrictionBacs getBacs() {
        return this.bacs;
    }

    public void setBacs(PaymentInitiationOptionalRestrictionBacs bacs) {
        this.bacs = bacs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExternalPaymentInitiationConsentOptions externalPaymentInitiationConsentOptions = (ExternalPaymentInitiationConsentOptions)o;
        return Objects.equals(this.requestRefundDetails, externalPaymentInitiationConsentOptions.requestRefundDetails) && Objects.equals(this.iban, externalPaymentInitiationConsentOptions.iban) && Objects.equals(this.bacs, externalPaymentInitiationConsentOptions.bacs);
    }

    public int hashCode() {
        return Objects.hash(this.requestRefundDetails, this.iban, this.bacs);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ExternalPaymentInitiationConsentOptions {\n");
        sb.append("    requestRefundDetails: ").append(this.toIndentedString(this.requestRefundDetails)).append("\n");
        sb.append("    iban: ").append(this.toIndentedString(this.iban)).append("\n");
        sb.append("    bacs: ").append(this.toIndentedString(this.bacs)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

