/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.PaymentInitiationOptionalRestrictionBacs;
import com.plaid.client.model.PaymentScheme;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Additional payment options")
public class ExternalPaymentOptions {
    public static final String SERIALIZED_NAME_REQUEST_REFUND_DETAILS = "request_refund_details";
    @SerializedName(value="request_refund_details")
    private Boolean requestRefundDetails;
    public static final String SERIALIZED_NAME_IBAN = "iban";
    @SerializedName(value="iban")
    private String iban;
    public static final String SERIALIZED_NAME_BACS = "bacs";
    @SerializedName(value="bacs")
    private PaymentInitiationOptionalRestrictionBacs bacs;
    public static final String SERIALIZED_NAME_SCHEME = "scheme";
    @SerializedName(value="scheme")
    private PaymentScheme scheme;

    public ExternalPaymentOptions requestRefundDetails(Boolean requestRefundDetails) {
        this.requestRefundDetails = requestRefundDetails;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="When `true`, Plaid will attempt to request refund details from the payee's financial institution.  Support varies between financial institutions and will not always be available.  If refund details could be retrieved, they will be available in the `/payment_initiation/payment/get` response.")
    public Boolean getRequestRefundDetails() {
        return this.requestRefundDetails;
    }

    public void setRequestRefundDetails(Boolean requestRefundDetails) {
        this.requestRefundDetails = requestRefundDetails;
    }

    public ExternalPaymentOptions iban(String iban) {
        this.iban = iban;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The International Bank Account Number (IBAN) for the payer's account. Where possible, the end user will be able to send payments only from the specified bank account if provided.")
    public String getIban() {
        return this.iban;
    }

    public void setIban(String iban) {
        this.iban = iban;
    }

    public ExternalPaymentOptions bacs(PaymentInitiationOptionalRestrictionBacs bacs) {
        this.bacs = bacs;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public PaymentInitiationOptionalRestrictionBacs getBacs() {
        return this.bacs;
    }

    public void setBacs(PaymentInitiationOptionalRestrictionBacs bacs) {
        this.bacs = bacs;
    }

    public ExternalPaymentOptions scheme(PaymentScheme scheme) {
        this.scheme = scheme;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public PaymentScheme getScheme() {
        return this.scheme;
    }

    public void setScheme(PaymentScheme scheme) {
        this.scheme = scheme;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExternalPaymentOptions externalPaymentOptions = (ExternalPaymentOptions)o;
        return Objects.equals(this.requestRefundDetails, externalPaymentOptions.requestRefundDetails) && Objects.equals(this.iban, externalPaymentOptions.iban) && Objects.equals(this.bacs, externalPaymentOptions.bacs) && Objects.equals((Object)this.scheme, (Object)externalPaymentOptions.scheme);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.requestRefundDetails, this.iban, this.bacs, this.scheme});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ExternalPaymentOptions {\n");
        sb.append("    requestRefundDetails: ").append(this.toIndentedString(this.requestRefundDetails)).append("\n");
        sb.append("    iban: ").append(this.toIndentedString(this.iban)).append("\n");
        sb.append("    bacs: ").append(this.toIndentedString(this.bacs)).append("\n");
        sb.append("    scheme: ").append(this.toIndentedString((Object)this.scheme)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

