/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.PaymentScheduleInterval;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="The schedule that the payment will be executed on. If a schedule is provided, the payment is automatically set up as a standing order. If no schedule is specified, the payment will be executed only once.")
public class ExternalPaymentScheduleBase {
    public static final String SERIALIZED_NAME_INTERVAL = "interval";
    @SerializedName(value="interval")
    private PaymentScheduleInterval interval;
    public static final String SERIALIZED_NAME_INTERVAL_EXECUTION_DAY = "interval_execution_day";
    @SerializedName(value="interval_execution_day")
    private Integer intervalExecutionDay;
    public static final String SERIALIZED_NAME_START_DATE = "start_date";
    @SerializedName(value="start_date")
    private LocalDate startDate;
    public static final String SERIALIZED_NAME_END_DATE = "end_date";
    @SerializedName(value="end_date")
    private LocalDate endDate;
    public static final String SERIALIZED_NAME_ADJUSTED_START_DATE = "adjusted_start_date";
    @SerializedName(value="adjusted_start_date")
    private LocalDate adjustedStartDate;

    public ExternalPaymentScheduleBase interval(PaymentScheduleInterval interval) {
        this.interval = interval;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public PaymentScheduleInterval getInterval() {
        return this.interval;
    }

    public void setInterval(PaymentScheduleInterval interval) {
        this.interval = interval;
    }

    public ExternalPaymentScheduleBase intervalExecutionDay(Integer intervalExecutionDay) {
        this.intervalExecutionDay = intervalExecutionDay;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The day of the interval on which to schedule the payment.  If the payment interval is weekly, `interval_execution_day` should be an integer from 1 (Monday) to 7 (Sunday).  If the payment interval is monthly, `interval_execution_day` should be an integer indicating which day of the month to make the payment on. Integers from 1 to 28 can be used to make a payment on that day of the month. Negative integers from -1 to -5 can be used to make a payment relative to the end of the month. To make a payment on the last day of the month, use -1; to make the payment on the second-to-last day, use -2, and so on.")
    public Integer getIntervalExecutionDay() {
        return this.intervalExecutionDay;
    }

    public void setIntervalExecutionDay(Integer intervalExecutionDay) {
        this.intervalExecutionDay = intervalExecutionDay;
    }

    public ExternalPaymentScheduleBase startDate(LocalDate startDate) {
        this.startDate = startDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A date in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format (YYYY-MM-DD). Standing order payments will begin on the first `interval_execution_day` on or after the `start_date`.  If the first `interval_execution_day` on or after the start date is also the same day that `/payment_initiation/payment/create` was called, the bank *may* make the first payment on that day, but it is not guaranteed to do so.")
    public LocalDate getStartDate() {
        return this.startDate;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }

    public ExternalPaymentScheduleBase endDate(LocalDate endDate) {
        this.endDate = endDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A date in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format (YYYY-MM-DD). Standing order payments will end on the last `interval_execution_day` on or before the `end_date`. If the only `interval_execution_day` between the start date and the end date (inclusive) is also the same day that `/payment_initiation/payment/create` was called, the bank *may* make a payment on that day, but it is not guaranteed to do so.")
    public LocalDate getEndDate() {
        return this.endDate;
    }

    public void setEndDate(LocalDate endDate) {
        this.endDate = endDate;
    }

    public ExternalPaymentScheduleBase adjustedStartDate(LocalDate adjustedStartDate) {
        this.adjustedStartDate = adjustedStartDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The start date sent to the bank after adjusting for holidays or weekends.  Will be provided in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format (YYYY-MM-DD). If the start date did not require adjustment, this field will be `null`.")
    public LocalDate getAdjustedStartDate() {
        return this.adjustedStartDate;
    }

    public void setAdjustedStartDate(LocalDate adjustedStartDate) {
        this.adjustedStartDate = adjustedStartDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExternalPaymentScheduleBase externalPaymentScheduleBase = (ExternalPaymentScheduleBase)o;
        return Objects.equals((Object)this.interval, (Object)externalPaymentScheduleBase.interval) && Objects.equals(this.intervalExecutionDay, externalPaymentScheduleBase.intervalExecutionDay) && Objects.equals(this.startDate, externalPaymentScheduleBase.startDate) && Objects.equals(this.endDate, externalPaymentScheduleBase.endDate) && Objects.equals(this.adjustedStartDate, externalPaymentScheduleBase.adjustedStartDate);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.interval, this.intervalExecutionDay, this.startDate, this.endDate, this.adjustedStartDate});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ExternalPaymentScheduleBase {\n");
        sb.append("    interval: ").append(this.toIndentedString((Object)this.interval)).append("\n");
        sb.append("    intervalExecutionDay: ").append(this.toIndentedString(this.intervalExecutionDay)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    adjustedStartDate: ").append(this.toIndentedString(this.adjustedStartDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

