/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.FDXContentTypes;
import com.plaid.client.model.FDXHateoasLinkAction;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="REST application constraint (Hypermedia As The Engine Of Application State)")
public class FDXHateoasLink {
    public static final String SERIALIZED_NAME_HREF = "href";
    @SerializedName(value="href")
    private String href;
    public static final String SERIALIZED_NAME_ACTION = "action";
    @SerializedName(value="action")
    private FDXHateoasLinkAction action;
    public static final String SERIALIZED_NAME_REL = "rel";
    @SerializedName(value="rel")
    private String rel;
    public static final String SERIALIZED_NAME_TYPES = "types";
    @SerializedName(value="types")
    private List<FDXContentTypes> types = null;

    public FDXHateoasLink href(String href) {
        this.href = href;
        return this;
    }

    @ApiModelProperty(example="https://api.fi.com/fdx/v4/accounts/12345", required=true, value="URL to invoke the action on the resource")
    public String getHref() {
        return this.href;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public FDXHateoasLink action(FDXHateoasLinkAction action) {
        this.action = action;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public FDXHateoasLinkAction getAction() {
        return this.action;
    }

    public void setAction(FDXHateoasLinkAction action) {
        this.action = action;
    }

    public FDXHateoasLink rel(String rel) {
        this.rel = rel;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Relation of this link to its containing entity, as defined by and with many example relation values at [IETF RFC5988](https://datatracker.ietf.org/doc/html/rfc5988)")
    public String getRel() {
        return this.rel;
    }

    public void setRel(String rel) {
        this.rel = rel;
    }

    public FDXHateoasLink types(List<FDXContentTypes> types) {
        this.types = types;
        return this;
    }

    public FDXHateoasLink addTypesItem(FDXContentTypes typesItem) {
        if (this.types == null) {
            this.types = new ArrayList<FDXContentTypes>();
        }
        this.types.add(typesItem);
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Content-types that can be used in the Accept header")
    public List<FDXContentTypes> getTypes() {
        return this.types;
    }

    public void setTypes(List<FDXContentTypes> types) {
        this.types = types;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FDXHateoasLink fdXHateoasLink = (FDXHateoasLink)o;
        return Objects.equals(this.href, fdXHateoasLink.href) && Objects.equals((Object)this.action, (Object)fdXHateoasLink.action) && Objects.equals(this.rel, fdXHateoasLink.rel) && Objects.equals(this.types, fdXHateoasLink.types);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.href, this.action, this.rel, this.types});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FDXHateoasLink {\n");
        sb.append("    href: ").append(this.toIndentedString(this.href)).append("\n");
        sb.append("    action: ").append(this.toIndentedString((Object)this.action)).append("\n");
        sb.append("    rel: ").append(this.toIndentedString(this.rel)).append("\n");
        sb.append("    types: ").append(this.toIndentedString(this.types)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

