/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.FDXHateoasLink;
import com.plaid.client.model.FDXNotificationCategory;
import com.plaid.client.model.FDXNotificationPayload;
import com.plaid.client.model.FDXNotificationPriority;
import com.plaid.client.model.FDXNotificationSeverity;
import com.plaid.client.model.FDXNotificationType;
import com.plaid.client.model.FDXParty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Provides the base fields of a notification. Clients will read the `type` property to determine the expected notification payload")
public class FDXNotification {
    public static final String SERIALIZED_NAME_NOTIFICATION_ID = "notificationId";
    @SerializedName(value="notificationId")
    private String notificationId;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private FDXNotificationType type;
    public static final String SERIALIZED_NAME_SENT_ON = "sentOn";
    @SerializedName(value="sentOn")
    private OffsetDateTime sentOn;
    public static final String SERIALIZED_NAME_CATEGORY = "category";
    @SerializedName(value="category")
    private FDXNotificationCategory category;
    public static final String SERIALIZED_NAME_SEVERITY = "severity";
    @SerializedName(value="severity")
    private FDXNotificationSeverity severity;
    public static final String SERIALIZED_NAME_PRIORITY = "priority";
    @SerializedName(value="priority")
    private FDXNotificationPriority priority;
    public static final String SERIALIZED_NAME_PUBLISHER = "publisher";
    @SerializedName(value="publisher")
    private FDXParty publisher;
    public static final String SERIALIZED_NAME_SUBSCRIBER = "subscriber";
    @SerializedName(value="subscriber")
    private FDXParty subscriber;
    public static final String SERIALIZED_NAME_NOTIFICATION_PAYLOAD = "notificationPayload";
    @SerializedName(value="notificationPayload")
    private FDXNotificationPayload notificationPayload;
    public static final String SERIALIZED_NAME_URL = "url";
    @SerializedName(value="url")
    private FDXHateoasLink url;

    public FDXNotification notificationId(String notificationId) {
        this.notificationId = notificationId;
        return this;
    }

    @ApiModelProperty(required=true, value="Id of notification")
    public String getNotificationId() {
        return this.notificationId;
    }

    public void setNotificationId(String notificationId) {
        this.notificationId = notificationId;
    }

    public FDXNotification type(FDXNotificationType type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public FDXNotificationType getType() {
        return this.type;
    }

    public void setType(FDXNotificationType type) {
        this.type = type;
    }

    public FDXNotification sentOn(OffsetDateTime sentOn) {
        this.sentOn = sentOn;
        return this;
    }

    @ApiModelProperty(example="2021-07-15T14:46:41.375Z", required=true, value="ISO 8601 date-time in format 'YYYY-MM-DDThh:mm:ss.nnn[Z|[+|-]hh:mm]' according to [IETF RFC3339](https://xml2rfc.tools.ietf.org/public/rfc/html/rfc3339.html#anchor14)")
    public OffsetDateTime getSentOn() {
        return this.sentOn;
    }

    public void setSentOn(OffsetDateTime sentOn) {
        this.sentOn = sentOn;
    }

    public FDXNotification category(FDXNotificationCategory category) {
        this.category = category;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public FDXNotificationCategory getCategory() {
        return this.category;
    }

    public void setCategory(FDXNotificationCategory category) {
        this.category = category;
    }

    public FDXNotification severity(FDXNotificationSeverity severity) {
        this.severity = severity;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public FDXNotificationSeverity getSeverity() {
        return this.severity;
    }

    public void setSeverity(FDXNotificationSeverity severity) {
        this.severity = severity;
    }

    public FDXNotification priority(FDXNotificationPriority priority) {
        this.priority = priority;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public FDXNotificationPriority getPriority() {
        return this.priority;
    }

    public void setPriority(FDXNotificationPriority priority) {
        this.priority = priority;
    }

    public FDXNotification publisher(FDXParty publisher) {
        this.publisher = publisher;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public FDXParty getPublisher() {
        return this.publisher;
    }

    public void setPublisher(FDXParty publisher) {
        this.publisher = publisher;
    }

    public FDXNotification subscriber(FDXParty subscriber) {
        this.subscriber = subscriber;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public FDXParty getSubscriber() {
        return this.subscriber;
    }

    public void setSubscriber(FDXParty subscriber) {
        this.subscriber = subscriber;
    }

    public FDXNotification notificationPayload(FDXNotificationPayload notificationPayload) {
        this.notificationPayload = notificationPayload;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public FDXNotificationPayload getNotificationPayload() {
        return this.notificationPayload;
    }

    public void setNotificationPayload(FDXNotificationPayload notificationPayload) {
        this.notificationPayload = notificationPayload;
    }

    public FDXNotification url(FDXHateoasLink url) {
        this.url = url;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public FDXHateoasLink getUrl() {
        return this.url;
    }

    public void setUrl(FDXHateoasLink url) {
        this.url = url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FDXNotification fdXNotification = (FDXNotification)o;
        return Objects.equals(this.notificationId, fdXNotification.notificationId) && Objects.equals((Object)this.type, (Object)fdXNotification.type) && Objects.equals(this.sentOn, fdXNotification.sentOn) && Objects.equals((Object)this.category, (Object)fdXNotification.category) && Objects.equals((Object)this.severity, (Object)fdXNotification.severity) && Objects.equals((Object)this.priority, (Object)fdXNotification.priority) && Objects.equals(this.publisher, fdXNotification.publisher) && Objects.equals(this.subscriber, fdXNotification.subscriber) && Objects.equals(this.notificationPayload, fdXNotification.notificationPayload) && Objects.equals(this.url, fdXNotification.url);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.notificationId, this.type, this.sentOn, this.category, this.severity, this.priority, this.publisher, this.subscriber, this.notificationPayload, this.url});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FDXNotification {\n");
        sb.append("    notificationId: ").append(this.toIndentedString(this.notificationId)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    sentOn: ").append(this.toIndentedString(this.sentOn)).append("\n");
        sb.append("    category: ").append(this.toIndentedString((Object)this.category)).append("\n");
        sb.append("    severity: ").append(this.toIndentedString((Object)this.severity)).append("\n");
        sb.append("    priority: ").append(this.toIndentedString((Object)this.priority)).append("\n");
        sb.append("    publisher: ").append(this.toIndentedString(this.publisher)).append("\n");
        sb.append("    subscriber: ").append(this.toIndentedString(this.subscriber)).append("\n");
        sb.append("    notificationPayload: ").append(this.toIndentedString(this.notificationPayload)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

