/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.FDXPartyRegistry;
import com.plaid.client.model.FDXPartyType;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.net.URI;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="FDX Participant - an entity or person that is a part of a FDX API transaction")
public class FDXParty {
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private FDXPartyType type;
    public static final String SERIALIZED_NAME_HOME_URI = "homeUri";
    @SerializedName(value="homeUri")
    private URI homeUri;
    public static final String SERIALIZED_NAME_LOGO_URI = "logoUri";
    @SerializedName(value="logoUri")
    private URI logoUri;
    public static final String SERIALIZED_NAME_REGISTRY = "registry";
    @SerializedName(value="registry")
    private FDXPartyRegistry registry;
    public static final String SERIALIZED_NAME_REGISTERED_ENTITY_NAME = "registeredEntityName";
    @SerializedName(value="registeredEntityName")
    private String registeredEntityName;
    public static final String SERIALIZED_NAME_REGISTERED_ENTITY_ID = "registeredEntityId";
    @SerializedName(value="registeredEntityId")
    private String registeredEntityId;

    public FDXParty name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="Human recognizable common name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public FDXParty type(FDXPartyType type) {
        this.type = type;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public FDXPartyType getType() {
        return this.type;
    }

    public void setType(FDXPartyType type) {
        this.type = type;
    }

    public FDXParty homeUri(URI homeUri) {
        this.homeUri = homeUri;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="URI for party, where an end user could learn more about the company or application involved in the data sharing chain")
    public URI getHomeUri() {
        return this.homeUri;
    }

    public void setHomeUri(URI homeUri) {
        this.homeUri = homeUri;
    }

    public FDXParty logoUri(URI logoUri) {
        this.logoUri = logoUri;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="URI for a logo asset to be displayed to the end user")
    public URI getLogoUri() {
        return this.logoUri;
    }

    public void setLogoUri(URI logoUri) {
        this.logoUri = logoUri;
    }

    public FDXParty registry(FDXPartyRegistry registry) {
        this.registry = registry;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public FDXPartyRegistry getRegistry() {
        return this.registry;
    }

    public void setRegistry(FDXPartyRegistry registry) {
        this.registry = registry;
    }

    public FDXParty registeredEntityName(String registeredEntityName) {
        this.registeredEntityName = registeredEntityName;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Registered name of party")
    public String getRegisteredEntityName() {
        return this.registeredEntityName;
    }

    public void setRegisteredEntityName(String registeredEntityName) {
        this.registeredEntityName = registeredEntityName;
    }

    public FDXParty registeredEntityId(String registeredEntityId) {
        this.registeredEntityId = registeredEntityId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Registered id of party")
    public String getRegisteredEntityId() {
        return this.registeredEntityId;
    }

    public void setRegisteredEntityId(String registeredEntityId) {
        this.registeredEntityId = registeredEntityId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FDXParty fdXParty = (FDXParty)o;
        return Objects.equals(this.name, fdXParty.name) && Objects.equals((Object)this.type, (Object)fdXParty.type) && Objects.equals(this.homeUri, fdXParty.homeUri) && Objects.equals(this.logoUri, fdXParty.logoUri) && Objects.equals((Object)this.registry, (Object)fdXParty.registry) && Objects.equals(this.registeredEntityName, fdXParty.registeredEntityName) && Objects.equals(this.registeredEntityId, fdXParty.registeredEntityId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.type, this.homeUri, this.logoUri, this.registry, this.registeredEntityName, this.registeredEntityId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FDXParty {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    homeUri: ").append(this.toIndentedString(this.homeUri)).append("\n");
        sb.append("    logoUri: ").append(this.toIndentedString(this.logoUri)).append("\n");
        sb.append("    registry: ").append(this.toIndentedString((Object)this.registry)).append("\n");
        sb.append("    registeredEntityName: ").append(this.toIndentedString(this.registeredEntityName)).append("\n");
        sb.append("    registeredEntityId: ").append(this.toIndentedString(this.registeredEntityId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

