/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.DetectedAccount;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="Insights surrounding external financial institution counterparties associated with a user.")
public class FinancialInstitutionInsights {
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_ENTITY_ID = "entity_id";
    @SerializedName(value="entity_id")
    private String entityId;
    public static final String SERIALIZED_NAME_WEBSITE = "website";
    @SerializedName(value="website")
    private String website;
    public static final String SERIALIZED_NAME_DETECTED_ACCOUNTS = "detected_accounts";
    @SerializedName(value="detected_accounts")
    private List<DetectedAccount> detectedAccounts = new ArrayList<DetectedAccount>();

    public FinancialInstitutionInsights name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="Name of the financial institution counterparty.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public FinancialInstitutionInsights entityId(String entityId) {
        this.entityId = entityId;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="A unique, stable, Plaid-generated id that maps to the counterparty.")
    public String getEntityId() {
        return this.entityId;
    }

    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    public FinancialInstitutionInsights website(String website) {
        this.website = website;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The website associated with the counterparty.")
    public String getWebsite() {
        return this.website;
    }

    public void setWebsite(String website) {
        this.website = website;
    }

    public FinancialInstitutionInsights detectedAccounts(List<DetectedAccount> detectedAccounts) {
        this.detectedAccounts = detectedAccounts;
        return this;
    }

    public FinancialInstitutionInsights addDetectedAccountsItem(DetectedAccount detectedAccountsItem) {
        this.detectedAccounts.add(detectedAccountsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Associated accounts, detected based on the nature of transfers to/from this institution.")
    public List<DetectedAccount> getDetectedAccounts() {
        return this.detectedAccounts;
    }

    public void setDetectedAccounts(List<DetectedAccount> detectedAccounts) {
        this.detectedAccounts = detectedAccounts;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FinancialInstitutionInsights financialInstitutionInsights = (FinancialInstitutionInsights)o;
        return Objects.equals(this.name, financialInstitutionInsights.name) && Objects.equals(this.entityId, financialInstitutionInsights.entityId) && Objects.equals(this.website, financialInstitutionInsights.website) && Objects.equals(this.detectedAccounts, financialInstitutionInsights.detectedAccounts);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.entityId, this.website, this.detectedAccounts);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FinancialInstitutionInsights {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    entityId: ").append(this.toIndentedString(this.entityId)).append("\n");
        sb.append("    website: ").append(this.toIndentedString(this.website)).append("\n");
        sb.append("    detectedAccounts: ").append(this.toIndentedString(this.detectedAccounts)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

