/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.ISOCurrencyCode;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="The amount and currency of the fraud or attempted fraud. `fraud_amount` should be omitted to indicate an unknown fraud amount.")
public class FraudAmount {
    public static final String SERIALIZED_NAME_ISO_CURRENCY_CODE = "iso_currency_code";
    @SerializedName(value="iso_currency_code")
    private ISOCurrencyCode isoCurrencyCode;
    public static final String SERIALIZED_NAME_VALUE = "value";
    @SerializedName(value="value")
    private Double value;

    public FraudAmount isoCurrencyCode(ISOCurrencyCode isoCurrencyCode) {
        this.isoCurrencyCode = isoCurrencyCode;
        return this;
    }

    @ApiModelProperty(required=true, value="")
    public ISOCurrencyCode getIsoCurrencyCode() {
        return this.isoCurrencyCode;
    }

    public void setIsoCurrencyCode(ISOCurrencyCode isoCurrencyCode) {
        this.isoCurrencyCode = isoCurrencyCode;
    }

    public FraudAmount value(Double value) {
        this.value = value;
        return this;
    }

    @ApiModelProperty(example="100", required=true, value="The amount value. This value can be 0 to indicate no money was lost. Must not contain more than two digits of precision (e.g., `1.23`).")
    public Double getValue() {
        return this.value;
    }

    public void setValue(Double value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FraudAmount fraudAmount = (FraudAmount)o;
        return Objects.equals((Object)this.isoCurrencyCode, (Object)fraudAmount.isoCurrencyCode) && Objects.equals(this.value, fraudAmount.value);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.isoCurrencyCode, this.value});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FraudAmount {\n");
        sb.append("    isoCurrencyCode: ").append(this.toIndentedString((Object)this.isoCurrencyCode)).append("\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

