/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import com.plaid.client.model.IncidentUpdate;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="A status health incident")
public class HealthIncident {
    public static final String SERIALIZED_NAME_START_DATE = "start_date";
    @SerializedName(value="start_date")
    private OffsetDateTime startDate;
    public static final String SERIALIZED_NAME_END_DATE = "end_date";
    @SerializedName(value="end_date")
    private OffsetDateTime endDate;
    public static final String SERIALIZED_NAME_TITLE = "title";
    @SerializedName(value="title")
    private String title;
    public static final String SERIALIZED_NAME_INCIDENT_UPDATES = "incident_updates";
    @SerializedName(value="incident_updates")
    private List<IncidentUpdate> incidentUpdates = new ArrayList<IncidentUpdate>();

    public HealthIncident startDate(OffsetDateTime startDate) {
        this.startDate = startDate;
        return this;
    }

    @ApiModelProperty(required=true, value="The start date of the incident, in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format, e.g. `\"2020-10-30T15:26:48Z\"`.")
    public OffsetDateTime getStartDate() {
        return this.startDate;
    }

    public void setStartDate(OffsetDateTime startDate) {
        this.startDate = startDate;
    }

    public HealthIncident endDate(OffsetDateTime endDate) {
        this.endDate = endDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The end date of the incident, in [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format, e.g. `\"2020-10-30T15:26:48Z\"`.")
    public OffsetDateTime getEndDate() {
        return this.endDate;
    }

    public void setEndDate(OffsetDateTime endDate) {
        this.endDate = endDate;
    }

    public HealthIncident title(String title) {
        this.title = title;
        return this;
    }

    @ApiModelProperty(required=true, value="The title of the incident")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public HealthIncident incidentUpdates(List<IncidentUpdate> incidentUpdates) {
        this.incidentUpdates = incidentUpdates;
        return this;
    }

    public HealthIncident addIncidentUpdatesItem(IncidentUpdate incidentUpdatesItem) {
        this.incidentUpdates.add(incidentUpdatesItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Updates on the health incident.")
    public List<IncidentUpdate> getIncidentUpdates() {
        return this.incidentUpdates;
    }

    public void setIncidentUpdates(List<IncidentUpdate> incidentUpdates) {
        this.incidentUpdates = incidentUpdates;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HealthIncident healthIncident = (HealthIncident)o;
        return Objects.equals(this.startDate, healthIncident.startDate) && Objects.equals(this.endDate, healthIncident.endDate) && Objects.equals(this.title, healthIncident.title) && Objects.equals(this.incidentUpdates, healthIncident.incidentUpdates);
    }

    public int hashCode() {
        return Objects.hash(this.startDate, this.endDate, this.title, this.incidentUpdates);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HealthIncident {\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    incidentUpdates: ").append(this.toIndentedString(this.incidentUpdates)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

