/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="An object representing a balance held by an account in the past")
public class HistoricalBalance {
    public static final String SERIALIZED_NAME_DATE = "date";
    @SerializedName(value="date")
    private LocalDate date;
    public static final String SERIALIZED_NAME_CURRENT = "current";
    @SerializedName(value="current")
    private Double current;
    public static final String SERIALIZED_NAME_ISO_CURRENCY_CODE = "iso_currency_code";
    @SerializedName(value="iso_currency_code")
    private String isoCurrencyCode;
    public static final String SERIALIZED_NAME_UNOFFICIAL_CURRENCY_CODE = "unofficial_currency_code";
    @SerializedName(value="unofficial_currency_code")
    private String unofficialCurrencyCode;

    public HistoricalBalance date(LocalDate date) {
        this.date = date;
        return this;
    }

    @ApiModelProperty(required=true, value="The date of the calculated historical balance, in an [ISO 8601](https://wikipedia.org/wiki/ISO_8601) format (YYYY-MM-DD)")
    public LocalDate getDate() {
        return this.date;
    }

    public void setDate(LocalDate date) {
        this.date = date;
    }

    public HistoricalBalance current(Double current) {
        this.current = current;
        return this;
    }

    @ApiModelProperty(required=true, value="The total amount of funds in the account, calculated from the `current` balance in the `balance` object by subtracting inflows and adding back outflows according to the posted date of each transaction.  If the account has any pending transactions, historical balance amounts on or after the date of the earliest pending transaction may differ if retrieved in subsequent Asset Reports as a result of those pending transactions posting.")
    public Double getCurrent() {
        return this.current;
    }

    public void setCurrent(Double current) {
        this.current = current;
    }

    public HistoricalBalance isoCurrencyCode(String isoCurrencyCode) {
        this.isoCurrencyCode = isoCurrencyCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The ISO-4217 currency code of the balance. Always `null` if `unofficial_currency_code` is non-`null`.")
    public String getIsoCurrencyCode() {
        return this.isoCurrencyCode;
    }

    public void setIsoCurrencyCode(String isoCurrencyCode) {
        this.isoCurrencyCode = isoCurrencyCode;
    }

    public HistoricalBalance unofficialCurrencyCode(String unofficialCurrencyCode) {
        this.unofficialCurrencyCode = unofficialCurrencyCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The unofficial currency code associated with the balance. Always `null` if `iso_currency_code` is non-`null`.  See the [currency code schema](https://plaid.com/docs/api/accounts#currency-code-schema) for a full listing of supported `unofficial_currency_code`s.")
    public String getUnofficialCurrencyCode() {
        return this.unofficialCurrencyCode;
    }

    public void setUnofficialCurrencyCode(String unofficialCurrencyCode) {
        this.unofficialCurrencyCode = unofficialCurrencyCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HistoricalBalance historicalBalance = (HistoricalBalance)o;
        return Objects.equals(this.date, historicalBalance.date) && Objects.equals(this.current, historicalBalance.current) && Objects.equals(this.isoCurrencyCode, historicalBalance.isoCurrencyCode) && Objects.equals(this.unofficialCurrencyCode, historicalBalance.unofficialCurrencyCode);
    }

    public int hashCode() {
        return Objects.hash(this.date, this.current, this.isoCurrencyCode, this.unofficialCurrencyCode);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class HistoricalBalance {\n");
        sb.append("    date: ").append(this.toIndentedString(this.date)).append("\n");
        sb.append("    current: ").append(this.toIndentedString(this.current)).append("\n");
        sb.append("    isoCurrencyCode: ").append(this.toIndentedString(this.isoCurrencyCode)).append("\n");
        sb.append("    unofficialCurrencyCode: ").append(this.toIndentedString(this.unofficialCurrencyCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

