/*
 * Decompiled with CFR 0.152.
 */
package com.plaid.client.model;

import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.util.Objects;
import javax.annotation.Nullable;

@ApiModel(description="A securities holding at an institution.")
public class Holding {
    public static final String SERIALIZED_NAME_ACCOUNT_ID = "account_id";
    @SerializedName(value="account_id")
    private String accountId;
    public static final String SERIALIZED_NAME_SECURITY_ID = "security_id";
    @SerializedName(value="security_id")
    private String securityId;
    public static final String SERIALIZED_NAME_INSTITUTION_PRICE = "institution_price";
    @SerializedName(value="institution_price")
    private Double institutionPrice;
    public static final String SERIALIZED_NAME_INSTITUTION_PRICE_AS_OF = "institution_price_as_of";
    @SerializedName(value="institution_price_as_of")
    private LocalDate institutionPriceAsOf;
    public static final String SERIALIZED_NAME_INSTITUTION_PRICE_DATETIME = "institution_price_datetime";
    @SerializedName(value="institution_price_datetime")
    private OffsetDateTime institutionPriceDatetime;
    public static final String SERIALIZED_NAME_INSTITUTION_VALUE = "institution_value";
    @SerializedName(value="institution_value")
    private Double institutionValue;
    public static final String SERIALIZED_NAME_COST_BASIS = "cost_basis";
    @SerializedName(value="cost_basis")
    private Double costBasis;
    public static final String SERIALIZED_NAME_QUANTITY = "quantity";
    @SerializedName(value="quantity")
    private Double quantity;
    public static final String SERIALIZED_NAME_ISO_CURRENCY_CODE = "iso_currency_code";
    @SerializedName(value="iso_currency_code")
    private String isoCurrencyCode;
    public static final String SERIALIZED_NAME_UNOFFICIAL_CURRENCY_CODE = "unofficial_currency_code";
    @SerializedName(value="unofficial_currency_code")
    private String unofficialCurrencyCode;
    public static final String SERIALIZED_NAME_VESTED_QUANTITY = "vested_quantity";
    @SerializedName(value="vested_quantity")
    private Double vestedQuantity;
    public static final String SERIALIZED_NAME_VESTED_VALUE = "vested_value";
    @SerializedName(value="vested_value")
    private Double vestedValue;

    public Holding accountId(String accountId) {
        this.accountId = accountId;
        return this;
    }

    @ApiModelProperty(required=true, value="The Plaid `account_id` associated with the holding.")
    public String getAccountId() {
        return this.accountId;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public Holding securityId(String securityId) {
        this.securityId = securityId;
        return this;
    }

    @ApiModelProperty(required=true, value="The Plaid `security_id` associated with the holding. Security data is not specific to a user's account; any user who held the same security at the same financial institution at the same time would have identical security data. The `security_id` for the same security will typically be the same across different institutions, but this is not guaranteed. The `security_id` does not typically change, but may change if inherent details of the security change due to a corporate action, for example, in the event of a ticker symbol change or CUSIP change.")
    public String getSecurityId() {
        return this.securityId;
    }

    public void setSecurityId(String securityId) {
        this.securityId = securityId;
    }

    public Holding institutionPrice(Double institutionPrice) {
        this.institutionPrice = institutionPrice;
        return this;
    }

    @ApiModelProperty(required=true, value="The last price given by the institution for this security.")
    public Double getInstitutionPrice() {
        return this.institutionPrice;
    }

    public void setInstitutionPrice(Double institutionPrice) {
        this.institutionPrice = institutionPrice;
    }

    public Holding institutionPriceAsOf(LocalDate institutionPriceAsOf) {
        this.institutionPriceAsOf = institutionPriceAsOf;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The date at which `institution_price` was current.")
    public LocalDate getInstitutionPriceAsOf() {
        return this.institutionPriceAsOf;
    }

    public void setInstitutionPriceAsOf(LocalDate institutionPriceAsOf) {
        this.institutionPriceAsOf = institutionPriceAsOf;
    }

    public Holding institutionPriceDatetime(OffsetDateTime institutionPriceDatetime) {
        this.institutionPriceDatetime = institutionPriceDatetime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Date and time at which `institution_price` was current, in ISO 8601 format (YYYY-MM-DDTHH:mm:ssZ).  This field is returned for select financial institutions and comes as provided by the institution. It may contain default time values (such as 00:00:00). ")
    public OffsetDateTime getInstitutionPriceDatetime() {
        return this.institutionPriceDatetime;
    }

    public void setInstitutionPriceDatetime(OffsetDateTime institutionPriceDatetime) {
        this.institutionPriceDatetime = institutionPriceDatetime;
    }

    public Holding institutionValue(Double institutionValue) {
        this.institutionValue = institutionValue;
        return this;
    }

    @ApiModelProperty(required=true, value="The value of the holding, as reported by the institution.")
    public Double getInstitutionValue() {
        return this.institutionValue;
    }

    public void setInstitutionValue(Double institutionValue) {
        this.institutionValue = institutionValue;
    }

    public Holding costBasis(Double costBasis) {
        this.costBasis = costBasis;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The total cost basis of the holding (e.g., the total amount spent to acquire all assets currently in the holding).")
    public Double getCostBasis() {
        return this.costBasis;
    }

    public void setCostBasis(Double costBasis) {
        this.costBasis = costBasis;
    }

    public Holding quantity(Double quantity) {
        this.quantity = quantity;
        return this;
    }

    @ApiModelProperty(required=true, value="The total quantity of the asset held, as reported by the financial institution. If the security is an option, `quantity` will reflect the total number of options (typically the number of contracts multiplied by 100), not the number of contracts.")
    public Double getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Double quantity) {
        this.quantity = quantity;
    }

    public Holding isoCurrencyCode(String isoCurrencyCode) {
        this.isoCurrencyCode = isoCurrencyCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The ISO-4217 currency code of the holding. Always `null` if `unofficial_currency_code` is non-`null`.")
    public String getIsoCurrencyCode() {
        return this.isoCurrencyCode;
    }

    public void setIsoCurrencyCode(String isoCurrencyCode) {
        this.isoCurrencyCode = isoCurrencyCode;
    }

    public Holding unofficialCurrencyCode(String unofficialCurrencyCode) {
        this.unofficialCurrencyCode = unofficialCurrencyCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(required=true, value="The unofficial currency code associated with the holding. Always `null` if `iso_currency_code` is non-`null`. Unofficial currency codes are used for currencies that do not have official ISO currency codes, such as cryptocurrencies and the currencies of certain countries.  See the [currency code schema](https://plaid.com/docs/api/accounts#currency-code-schema) for a full listing of supported `iso_currency_code`s. ")
    public String getUnofficialCurrencyCode() {
        return this.unofficialCurrencyCode;
    }

    public void setUnofficialCurrencyCode(String unofficialCurrencyCode) {
        this.unofficialCurrencyCode = unofficialCurrencyCode;
    }

    public Holding vestedQuantity(Double vestedQuantity) {
        this.vestedQuantity = vestedQuantity;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The total quantity of vested assets held, as reported by the financial institution. Vested assets are only associated with [equities](https://plaid.com/docs/api/products/investments/#investments-holdings-get-response-securities-type).")
    public Double getVestedQuantity() {
        return this.vestedQuantity;
    }

    public void setVestedQuantity(Double vestedQuantity) {
        this.vestedQuantity = vestedQuantity;
    }

    public Holding vestedValue(Double vestedValue) {
        this.vestedValue = vestedValue;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="The value of the vested holdings as reported by the institution.")
    public Double getVestedValue() {
        return this.vestedValue;
    }

    public void setVestedValue(Double vestedValue) {
        this.vestedValue = vestedValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Holding holding = (Holding)o;
        return Objects.equals(this.accountId, holding.accountId) && Objects.equals(this.securityId, holding.securityId) && Objects.equals(this.institutionPrice, holding.institutionPrice) && Objects.equals(this.institutionPriceAsOf, holding.institutionPriceAsOf) && Objects.equals(this.institutionPriceDatetime, holding.institutionPriceDatetime) && Objects.equals(this.institutionValue, holding.institutionValue) && Objects.equals(this.costBasis, holding.costBasis) && Objects.equals(this.quantity, holding.quantity) && Objects.equals(this.isoCurrencyCode, holding.isoCurrencyCode) && Objects.equals(this.unofficialCurrencyCode, holding.unofficialCurrencyCode) && Objects.equals(this.vestedQuantity, holding.vestedQuantity) && Objects.equals(this.vestedValue, holding.vestedValue);
    }

    public int hashCode() {
        return Objects.hash(this.accountId, this.securityId, this.institutionPrice, this.institutionPriceAsOf, this.institutionPriceDatetime, this.institutionValue, this.costBasis, this.quantity, this.isoCurrencyCode, this.unofficialCurrencyCode, this.vestedQuantity, this.vestedValue);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Holding {\n");
        sb.append("    accountId: ").append(this.toIndentedString(this.accountId)).append("\n");
        sb.append("    securityId: ").append(this.toIndentedString(this.securityId)).append("\n");
        sb.append("    institutionPrice: ").append(this.toIndentedString(this.institutionPrice)).append("\n");
        sb.append("    institutionPriceAsOf: ").append(this.toIndentedString(this.institutionPriceAsOf)).append("\n");
        sb.append("    institutionPriceDatetime: ").append(this.toIndentedString(this.institutionPriceDatetime)).append("\n");
        sb.append("    institutionValue: ").append(this.toIndentedString(this.institutionValue)).append("\n");
        sb.append("    costBasis: ").append(this.toIndentedString(this.costBasis)).append("\n");
        sb.append("    quantity: ").append(this.toIndentedString(this.quantity)).append("\n");
        sb.append("    isoCurrencyCode: ").append(this.toIndentedString(this.isoCurrencyCode)).append("\n");
        sb.append("    unofficialCurrencyCode: ").append(this.toIndentedString(this.unofficialCurrencyCode)).append("\n");
        sb.append("    vestedQuantity: ").append(this.toIndentedString(this.vestedQuantity)).append("\n");
        sb.append("    vestedValue: ").append(this.toIndentedString(this.vestedValue)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

